/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class DatabaseUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseUpdate.class);
    @JsonProperty(value="properties.clientProtocol")
    private Protocol clientProtocol;
    @JsonProperty(value="properties.port")
    private Integer port;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private ResourceState resourceState;
    @JsonProperty(value="properties.clusteringPolicy")
    private ClusteringPolicy clusteringPolicy;
    @JsonProperty(value="properties.evictionPolicy")
    private EvictionPolicy evictionPolicy;
    @JsonProperty(value="properties.persistence")
    private Persistence persistence;
    @JsonProperty(value="properties.modules")
    private List<Module> modules;

    public Protocol clientProtocol() {
        return this.clientProtocol;
    }

    public DatabaseUpdate withClientProtocol(Protocol clientProtocol) {
        this.clientProtocol = clientProtocol;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public DatabaseUpdate withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    public ClusteringPolicy clusteringPolicy() {
        return this.clusteringPolicy;
    }

    public DatabaseUpdate withClusteringPolicy(ClusteringPolicy clusteringPolicy) {
        this.clusteringPolicy = clusteringPolicy;
        return this;
    }

    public EvictionPolicy evictionPolicy() {
        return this.evictionPolicy;
    }

    public DatabaseUpdate withEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public Persistence persistence() {
        return this.persistence;
    }

    public DatabaseUpdate withPersistence(Persistence persistence) {
        this.persistence = persistence;
        return this;
    }

    public List<Module> modules() {
        return this.modules;
    }

    public DatabaseUpdate withModules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public void validate() {
        if (this.persistence() != null) {
            this.persistence().validate();
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
    }
}

