// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** A facet whose execution resulted in an error. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "resultType")
@JsonTypeName("FacetError")
@Fluent
public final class FacetError extends Facet {
    /*
     * An array containing detected facet errors with details.
     */
    @JsonProperty(value = "errors", required = true)
    private List<ErrorDetails> errors;

    /** Creates an instance of FacetError class. */
    public FacetError() {
    }

    /**
     * Get the errors property: An array containing detected facet errors with details.
     *
     * @return the errors value.
     */
    public List<ErrorDetails> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: An array containing detected facet errors with details.
     *
     * @param errors the errors value to set.
     * @return the FacetError object itself.
     */
    public FacetError withErrors(List<ErrorDetails> errors) {
        this.errors = errors;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FacetError withExpression(String expression) {
        super.withExpression(expression);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (errors() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property errors in model FacetError"));
        } else {
            errors().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FacetError.class);
}
