// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** The sorting order by the selected column (count by default). */
public enum FacetSortOrder {
    /** Enum value asc. */
    ASC("asc"),

    /** Enum value desc. */
    DESC("desc");

    /** The actual serialized value for a FacetSortOrder instance. */
    private final String value;

    FacetSortOrder(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FacetSortOrder instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed FacetSortOrder object, or null if unable to parse.
     */
    @JsonCreator
    public static FacetSortOrder fromString(String value) {
        if (value == null) {
            return null;
        }
        FacetSortOrder[] items = FacetSortOrder.values();
        for (FacetSortOrder item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
