// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resourcegraph.fluent.models.OperationInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result of the request to list Resource Graph operations. It contains a list of operations and a URL link to get the
 * next set of results.
 */
@Fluent
public final class OperationListResult {
    /*
     * List of Resource Graph operations supported by the Resource Graph resource provider.
     */
    @JsonProperty(value = "value")
    private List<OperationInner> value;

    /** Creates an instance of OperationListResult class. */
    public OperationListResult() {
    }

    /**
     * Get the value property: List of Resource Graph operations supported by the Resource Graph resource provider.
     *
     * @return the value value.
     */
    public List<OperationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Resource Graph operations supported by the Resource Graph resource provider.
     *
     * @param value the value value to set.
     * @return the OperationListResult object itself.
     */
    public OperationListResult withValue(List<OperationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
