// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resourcegraph.fluent.models.GraphQueryResourceInner;
import com.azure.resourcemanager.resourcegraph.models.GraphQueryUpdateParameters;

/**
 * An instance of this class provides access to all the operations defined in GraphQueriesClient.
 */
public interface GraphQueriesClient {
    /**
     * Get all graph queries defined within a specified subscription.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GraphQueryResourceInner> list(String subscriptionId);

    /**
     * Get all graph queries defined within a specified subscription.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GraphQueryResourceInner> list(String subscriptionId, Context context);

    /**
     * Get all graph queries defined within a specified subscription and resource group.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GraphQueryResourceInner> listByResourceGroup(String subscriptionId, String resourceGroupName);

    /**
     * Get all graph queries defined within a specified subscription and resource group.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GraphQueryResourceInner> listByResourceGroup(String subscriptionId, String resourceGroupName,
        Context context);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GraphQueryResourceInner> getByResourceGroupWithResponse(String subscriptionId, String resourceGroupName,
        String resourceName, Context context);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GraphQueryResourceInner getByResourceGroup(String subscriptionId, String resourceGroupName, String resourceName);

    /**
     * Delete a graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String resourceName,
        Context context);

    /**
     * Delete a graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String subscriptionId, String resourceGroupName, String resourceName);

    /**
     * Create a new graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param properties Properties that need to be specified to create a new graph query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return graph Query entity definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GraphQueryResourceInner> createOrUpdateWithResponse(String subscriptionId, String resourceGroupName,
        String resourceName, GraphQueryResourceInner properties, Context context);

    /**
     * Create a new graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param properties Properties that need to be specified to create a new graph query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return graph Query entity definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GraphQueryResourceInner createOrUpdate(String subscriptionId, String resourceGroupName, String resourceName,
        GraphQueryResourceInner properties);

    /**
     * Updates a graph query that has already been added.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param body Properties that need to be specified to create a new graph query.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return graph Query entity definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GraphQueryResourceInner> updateWithResponse(String subscriptionId, String resourceGroupName,
        String resourceName, GraphQueryUpdateParameters body, Context context);

    /**
     * Updates a graph query that has already been added.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param body Properties that need to be specified to create a new graph query.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return graph Query entity definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GraphQueryResourceInner update(String subscriptionId, String resourceGroupName, String resourceName,
        GraphQueryUpdateParameters body);
}
