// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resourcegraph.models.ResultKind;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties that contain a graph query.
 */
@Fluent
public final class GraphQueryProperties implements JsonSerializable<GraphQueryProperties> {
    /*
     * Date and time in UTC of the last modification that was made to this graph query definition.
     */
    private OffsetDateTime timeModified;

    /*
     * The description of a graph query.
     */
    private String description;

    /*
     * KQL query that will be graph.
     */
    private String query;

    /*
     * Enum indicating a type of graph query.
     */
    private ResultKind resultKind;

    /**
     * Creates an instance of GraphQueryProperties class.
     */
    public GraphQueryProperties() {
    }

    /**
     * Get the timeModified property: Date and time in UTC of the last modification that was made to this graph query
     * definition.
     * 
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    /**
     * Get the description property: The description of a graph query.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of a graph query.
     * 
     * @param description the description value to set.
     * @return the GraphQueryProperties object itself.
     */
    public GraphQueryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the query property: KQL query that will be graph.
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: KQL query that will be graph.
     * 
     * @param query the query value to set.
     * @return the GraphQueryProperties object itself.
     */
    public GraphQueryProperties withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the resultKind property: Enum indicating a type of graph query.
     * 
     * @return the resultKind value.
     */
    public ResultKind resultKind() {
        return this.resultKind;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (query() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property query in model GraphQueryProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GraphQueryProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphQueryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphQueryProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GraphQueryProperties.
     */
    public static GraphQueryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphQueryProperties deserializedGraphQueryProperties = new GraphQueryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("query".equals(fieldName)) {
                    deserializedGraphQueryProperties.query = reader.getString();
                } else if ("timeModified".equals(fieldName)) {
                    deserializedGraphQueryProperties.timeModified = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedGraphQueryProperties.description = reader.getString();
                } else if ("resultKind".equals(fieldName)) {
                    deserializedGraphQueryProperties.resultKind = ResultKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphQueryProperties;
        });
    }
}
