// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties that contain a workbook for PATCH operation.
 */
@Fluent
public final class GraphQueryPropertiesUpdateParameters
    implements JsonSerializable<GraphQueryPropertiesUpdateParameters> {
    /*
     * The description of a graph query.
     */
    private String description;

    /*
     * KQL query that will be graph.
     */
    private String query;

    /**
     * Creates an instance of GraphQueryPropertiesUpdateParameters class.
     */
    public GraphQueryPropertiesUpdateParameters() {
    }

    /**
     * Get the description property: The description of a graph query.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of a graph query.
     * 
     * @param description the description value to set.
     * @return the GraphQueryPropertiesUpdateParameters object itself.
     */
    public GraphQueryPropertiesUpdateParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the query property: KQL query that will be graph.
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: KQL query that will be graph.
     * 
     * @param query the query value to set.
     * @return the GraphQueryPropertiesUpdateParameters object itself.
     */
    public GraphQueryPropertiesUpdateParameters withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("query", this.query);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphQueryPropertiesUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphQueryPropertiesUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GraphQueryPropertiesUpdateParameters.
     */
    public static GraphQueryPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphQueryPropertiesUpdateParameters deserializedGraphQueryPropertiesUpdateParameters
                = new GraphQueryPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedGraphQueryPropertiesUpdateParameters.description = reader.getString();
                } else if ("query".equals(fieldName)) {
                    deserializedGraphQueryPropertiesUpdateParameters.query = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphQueryPropertiesUpdateParameters;
        });
    }
}
