// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resourcegraph.models.ResultKind;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Graph Query entity definition.
 */
@Fluent
public final class GraphQueryResourceInner extends Resource {
    /*
     * Metadata describing a graph query for an Azure resource.
     */
    private GraphQueryProperties innerProperties;

    /*
     * This will be used to handle Optimistic Concurrency. If not present, it will always overwrite the existing
     * resource without checking conflict.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GraphQueryResourceInner class.
     */
    public GraphQueryResourceInner() {
    }

    /**
     * Get the innerProperties property: Metadata describing a graph query for an Azure resource.
     * 
     * @return the innerProperties value.
     */
    private GraphQueryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: This will be used to handle Optimistic Concurrency. If not present, it will always
     * overwrite the existing resource without checking conflict.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: This will be used to handle Optimistic Concurrency. If not present, it will always
     * overwrite the existing resource without checking conflict.
     * 
     * @param etag the etag value to set.
     * @return the GraphQueryResourceInner object itself.
     */
    public GraphQueryResourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphQueryResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GraphQueryResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the timeModified property: Date and time in UTC of the last modification that was made to this graph query
     * definition.
     * 
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    /**
     * Get the description property: The description of a graph query.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of a graph query.
     * 
     * @param description the description value to set.
     * @return the GraphQueryResourceInner object itself.
     */
    public GraphQueryResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GraphQueryProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the query property: KQL query that will be graph.
     * 
     * @return the query value.
     */
    public String query() {
        return this.innerProperties() == null ? null : this.innerProperties().query();
    }

    /**
     * Set the query property: KQL query that will be graph.
     * 
     * @param query the query value to set.
     * @return the GraphQueryResourceInner object itself.
     */
    public GraphQueryResourceInner withQuery(String query) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GraphQueryProperties();
        }
        this.innerProperties().withQuery(query);
        return this;
    }

    /**
     * Get the resultKind property: Enum indicating a type of graph query.
     * 
     * @return the resultKind value.
     */
    public ResultKind resultKind() {
        return this.innerProperties() == null ? null : this.innerProperties().resultKind();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphQueryResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphQueryResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GraphQueryResourceInner.
     */
    public static GraphQueryResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphQueryResourceInner deserializedGraphQueryResourceInner = new GraphQueryResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGraphQueryResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.innerProperties = GraphQueryProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedGraphQueryResourceInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphQueryResourceInner;
        });
    }
}
