// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.implementation;

import com.azure.resourcemanager.resourcegraph.fluent.models.QueryResponseInner;
import com.azure.resourcemanager.resourcegraph.models.Facet;
import com.azure.resourcemanager.resourcegraph.models.QueryResponse;
import com.azure.resourcemanager.resourcegraph.models.ResultTruncated;
import java.util.Collections;
import java.util.List;

public final class QueryResponseImpl implements QueryResponse {
    private QueryResponseInner innerObject;

    private final com.azure.resourcemanager.resourcegraph.ResourceGraphManager serviceManager;

    QueryResponseImpl(QueryResponseInner innerObject,
        com.azure.resourcemanager.resourcegraph.ResourceGraphManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public long totalRecords() {
        return this.innerModel().totalRecords();
    }

    public long count() {
        return this.innerModel().count();
    }

    public ResultTruncated resultTruncated() {
        return this.innerModel().resultTruncated();
    }

    public String skipToken() {
        return this.innerModel().skipToken();
    }

    public Object data() {
        return this.innerModel().data();
    }

    public List<Facet> facets() {
        List<Facet> inner = this.innerModel().facets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public QueryResponseInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.resourcegraph.ResourceGraphManager manager() {
        return this.serviceManager;
    }
}
