// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A facet containing additional statistics on the response of a query. Can be either FacetResult or FacetError.
 */
@Fluent
public class Facet implements JsonSerializable<Facet> {
    /*
     * Result type
     */
    private String resultType = "Facet";

    /*
     * Facet expression, same as in the corresponding facet request.
     */
    private String expression;

    /**
     * Creates an instance of Facet class.
     */
    public Facet() {
    }

    /**
     * Get the resultType property: Result type.
     * 
     * @return the resultType value.
     */
    public String resultType() {
        return this.resultType;
    }

    /**
     * Get the expression property: Facet expression, same as in the corresponding facet request.
     * 
     * @return the expression value.
     */
    public String expression() {
        return this.expression;
    }

    /**
     * Set the expression property: Facet expression, same as in the corresponding facet request.
     * 
     * @param expression the expression value to set.
     * @return the Facet object itself.
     */
    public Facet withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property expression in model Facet"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Facet.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expression", this.expression);
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Facet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Facet if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Facet.
     */
    public static Facet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("resultType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("FacetResult".equals(discriminatorValue)) {
                    return FacetResult.fromJson(readerToUse.reset());
                } else if ("FacetError".equals(discriminatorValue)) {
                    return FacetError.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static Facet fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Facet deserializedFacet = new Facet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expression".equals(fieldName)) {
                    deserializedFacet.expression = reader.getString();
                } else if ("resultType".equals(fieldName)) {
                    deserializedFacet.resultType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFacet;
        });
    }
}
