// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request to compute additional statistics (facets) over the query results.
 */
@Fluent
public final class FacetRequest implements JsonSerializable<FacetRequest> {
    /*
     * The column or list of columns to summarize by
     */
    private String expression;

    /*
     * The options for facet evaluation
     */
    private FacetRequestOptions options;

    /**
     * Creates an instance of FacetRequest class.
     */
    public FacetRequest() {
    }

    /**
     * Get the expression property: The column or list of columns to summarize by.
     * 
     * @return the expression value.
     */
    public String expression() {
        return this.expression;
    }

    /**
     * Set the expression property: The column or list of columns to summarize by.
     * 
     * @param expression the expression value to set.
     * @return the FacetRequest object itself.
     */
    public FacetRequest withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the options property: The options for facet evaluation.
     * 
     * @return the options value.
     */
    public FacetRequestOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The options for facet evaluation.
     * 
     * @param options the options value to set.
     * @return the FacetRequest object itself.
     */
    public FacetRequest withOptions(FacetRequestOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property expression in model FacetRequest"));
        }
        if (options() != null) {
            options().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FacetRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expression", this.expression);
        jsonWriter.writeJsonField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FacetRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FacetRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FacetRequest.
     */
    public static FacetRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FacetRequest deserializedFacetRequest = new FacetRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expression".equals(fieldName)) {
                    deserializedFacetRequest.expression = reader.getString();
                } else if ("options".equals(fieldName)) {
                    deserializedFacetRequest.options = FacetRequestOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFacetRequest;
        });
    }
}
