// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The options for facet evaluation.
 */
@Fluent
public final class FacetRequestOptions implements JsonSerializable<FacetRequestOptions> {
    /*
     * The column name or query expression to sort on. Defaults to count if not present.
     */
    private String sortBy;

    /*
     * The sorting order by the selected column (count by default).
     */
    private FacetSortOrder sortOrder;

    /*
     * Specifies the filter condition for the 'where' clause which will be run on main query's result, just before the
     * actual faceting.
     */
    private String filter;

    /*
     * The maximum number of facet rows that should be returned.
     */
    private Integer top;

    /**
     * Creates an instance of FacetRequestOptions class.
     */
    public FacetRequestOptions() {
    }

    /**
     * Get the sortBy property: The column name or query expression to sort on. Defaults to count if not present.
     * 
     * @return the sortBy value.
     */
    public String sortBy() {
        return this.sortBy;
    }

    /**
     * Set the sortBy property: The column name or query expression to sort on. Defaults to count if not present.
     * 
     * @param sortBy the sortBy value to set.
     * @return the FacetRequestOptions object itself.
     */
    public FacetRequestOptions withSortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    /**
     * Get the sortOrder property: The sorting order by the selected column (count by default).
     * 
     * @return the sortOrder value.
     */
    public FacetSortOrder sortOrder() {
        return this.sortOrder;
    }

    /**
     * Set the sortOrder property: The sorting order by the selected column (count by default).
     * 
     * @param sortOrder the sortOrder value to set.
     * @return the FacetRequestOptions object itself.
     */
    public FacetRequestOptions withSortOrder(FacetSortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    /**
     * Get the filter property: Specifies the filter condition for the 'where' clause which will be run on main query's
     * result, just before the actual faceting.
     * 
     * @return the filter value.
     */
    public String filter() {
        return this.filter;
    }

    /**
     * Set the filter property: Specifies the filter condition for the 'where' clause which will be run on main query's
     * result, just before the actual faceting.
     * 
     * @param filter the filter value to set.
     * @return the FacetRequestOptions object itself.
     */
    public FacetRequestOptions withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the top property: The maximum number of facet rows that should be returned.
     * 
     * @return the top value.
     */
    public Integer top() {
        return this.top;
    }

    /**
     * Set the top property: The maximum number of facet rows that should be returned.
     * 
     * @param top the top value to set.
     * @return the FacetRequestOptions object itself.
     */
    public FacetRequestOptions withTop(Integer top) {
        this.top = top;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sortBy", this.sortBy);
        jsonWriter.writeStringField("sortOrder", this.sortOrder == null ? null : this.sortOrder.toString());
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeNumberField("$top", this.top);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FacetRequestOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FacetRequestOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FacetRequestOptions.
     */
    public static FacetRequestOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FacetRequestOptions deserializedFacetRequestOptions = new FacetRequestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sortBy".equals(fieldName)) {
                    deserializedFacetRequestOptions.sortBy = reader.getString();
                } else if ("sortOrder".equals(fieldName)) {
                    deserializedFacetRequestOptions.sortOrder = FacetSortOrder.fromString(reader.getString());
                } else if ("filter".equals(fieldName)) {
                    deserializedFacetRequestOptions.filter = reader.getString();
                } else if ("$top".equals(fieldName)) {
                    deserializedFacetRequestOptions.top = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFacetRequestOptions;
        });
    }
}
