// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Successfully executed facet containing additional statistics on the response of a query.
 */
@Fluent
public final class FacetResult extends Facet {
    /*
     * Result type
     */
    private String resultType = "FacetResult";

    /*
     * Number of total records in the facet results.
     */
    private long totalRecords;

    /*
     * Number of records returned in the facet response.
     */
    private int count;

    /*
     * A JObject array or Table containing the desired facets. Only present if the facet is valid.
     */
    private Object data;

    /**
     * Creates an instance of FacetResult class.
     */
    public FacetResult() {
    }

    /**
     * Get the resultType property: Result type.
     * 
     * @return the resultType value.
     */
    @Override
    public String resultType() {
        return this.resultType;
    }

    /**
     * Get the totalRecords property: Number of total records in the facet results.
     * 
     * @return the totalRecords value.
     */
    public long totalRecords() {
        return this.totalRecords;
    }

    /**
     * Set the totalRecords property: Number of total records in the facet results.
     * 
     * @param totalRecords the totalRecords value to set.
     * @return the FacetResult object itself.
     */
    public FacetResult withTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
        return this;
    }

    /**
     * Get the count property: Number of records returned in the facet response.
     * 
     * @return the count value.
     */
    public int count() {
        return this.count;
    }

    /**
     * Set the count property: Number of records returned in the facet response.
     * 
     * @param count the count value to set.
     * @return the FacetResult object itself.
     */
    public FacetResult withCount(int count) {
        this.count = count;
        return this;
    }

    /**
     * Get the data property: A JObject array or Table containing the desired facets. Only present if the facet is
     * valid.
     * 
     * @return the data value.
     */
    public Object data() {
        return this.data;
    }

    /**
     * Set the data property: A JObject array or Table containing the desired facets. Only present if the facet is
     * valid.
     * 
     * @param data the data value to set.
     * @return the FacetResult object itself.
     */
    public FacetResult withData(Object data) {
        this.data = data;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FacetResult withExpression(String expression) {
        super.withExpression(expression);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (data() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property data in model FacetResult"));
        }
        if (expression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property expression in model FacetResult"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FacetResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expression", expression());
        jsonWriter.writeLongField("totalRecords", this.totalRecords);
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeUntypedField("data", this.data);
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FacetResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FacetResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FacetResult.
     */
    public static FacetResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FacetResult deserializedFacetResult = new FacetResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expression".equals(fieldName)) {
                    deserializedFacetResult.withExpression(reader.getString());
                } else if ("totalRecords".equals(fieldName)) {
                    deserializedFacetResult.totalRecords = reader.getLong();
                } else if ("count".equals(fieldName)) {
                    deserializedFacetResult.count = reader.getInt();
                } else if ("data".equals(fieldName)) {
                    deserializedFacetResult.data = reader.readUntyped();
                } else if ("resultType".equals(fieldName)) {
                    deserializedFacetResult.resultType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFacetResult;
        });
    }
}
