// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of GraphQueries.
 */
public interface GraphQueries {
    /**
     * Get all graph queries defined within a specified subscription.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<GraphQueryResource> list(String subscriptionId);

    /**
     * Get all graph queries defined within a specified subscription.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<GraphQueryResource> list(String subscriptionId, Context context);

    /**
     * Get all graph queries defined within a specified subscription and resource group.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<GraphQueryResource> listByResourceGroup(String subscriptionId, String resourceGroupName);

    /**
     * Get all graph queries defined within a specified subscription and resource group.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all graph queries defined within a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<GraphQueryResource> listByResourceGroup(String subscriptionId, String resourceGroupName,
        Context context);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName along with {@link Response}.
     */
    Response<GraphQueryResource> getByResourceGroupWithResponse(String subscriptionId, String resourceGroupName,
        String resourceName, Context context);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName.
     */
    GraphQueryResource getByResourceGroup(String subscriptionId, String resourceGroupName, String resourceName);

    /**
     * Delete a graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String resourceName,
        Context context);

    /**
     * Delete a graph query.
     * 
     * @param subscriptionId The Azure subscription Id.
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String subscriptionId, String resourceGroupName, String resourceName);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName along with {@link Response}.
     */
    GraphQueryResource getById(String id);

    /**
     * Get a single graph query by its resourceName.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single graph query by its resourceName along with {@link Response}.
     */
    Response<GraphQueryResource> getByIdWithResponse(String id, Context context);

    /**
     * Delete a graph query.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete a graph query.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new GraphQueryResource resource.
     * 
     * @param name resource name.
     * @return the first stage of the new GraphQueryResource definition.
     */
    GraphQueryResource.DefinitionStages.Blank define(String name);
}
