// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resourcegraph.fluent.models.GraphQueryResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Graph query list result.
 */
@Fluent
public final class GraphQueryListResult implements JsonSerializable<GraphQueryListResult> {
    /*
     * URL to fetch the next set of queries.
     */
    private String nextLink;

    /*
     * An array of graph queries.
     */
    private List<GraphQueryResourceInner> value;

    /**
     * Creates an instance of GraphQueryListResult class.
     */
    public GraphQueryListResult() {
    }

    /**
     * Get the nextLink property: URL to fetch the next set of queries.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to fetch the next set of queries.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GraphQueryListResult object itself.
     */
    public GraphQueryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: An array of graph queries.
     * 
     * @return the value value.
     */
    public List<GraphQueryResourceInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphQueryListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphQueryListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GraphQueryListResult.
     */
    public static GraphQueryListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphQueryListResult deserializedGraphQueryListResult = new GraphQueryListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextLink".equals(fieldName)) {
                    deserializedGraphQueryListResult.nextLink = reader.getString();
                } else if ("value".equals(fieldName)) {
                    List<GraphQueryResourceInner> value
                        = reader.readArray(reader1 -> GraphQueryResourceInner.fromJson(reader1));
                    deserializedGraphQueryListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphQueryListResult;
        });
    }
}
