// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resourcegraph.fluent.models.GraphQueryPropertiesUpdateParameters;
import java.io.IOException;
import java.util.Map;

/**
 * The parameters that can be provided when updating workbook properties properties.
 */
@Fluent
public final class GraphQueryUpdateParameters implements JsonSerializable<GraphQueryUpdateParameters> {
    /*
     * Resource tags
     */
    private Map<String, String> tags;

    /*
     * This will be used to handle Optimistic Concurrency. If not present, it will always overwrite the existing
     * resource without checking conflict.
     */
    private String etag;

    /*
     * Metadata describing a graph query for an Azure resource.
     */
    private GraphQueryPropertiesUpdateParameters innerProperties;

    /**
     * Creates an instance of GraphQueryUpdateParameters class.
     */
    public GraphQueryUpdateParameters() {
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the GraphQueryUpdateParameters object itself.
     */
    public GraphQueryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the etag property: This will be used to handle Optimistic Concurrency. If not present, it will always
     * overwrite the existing resource without checking conflict.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: This will be used to handle Optimistic Concurrency. If not present, it will always
     * overwrite the existing resource without checking conflict.
     * 
     * @param etag the etag value to set.
     * @return the GraphQueryUpdateParameters object itself.
     */
    public GraphQueryUpdateParameters withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the innerProperties property: Metadata describing a graph query for an Azure resource.
     * 
     * @return the innerProperties value.
     */
    private GraphQueryPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the description property: The description of a graph query.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of a graph query.
     * 
     * @param description the description value to set.
     * @return the GraphQueryUpdateParameters object itself.
     */
    public GraphQueryUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GraphQueryPropertiesUpdateParameters();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the query property: KQL query that will be graph.
     * 
     * @return the query value.
     */
    public String query() {
        return this.innerProperties() == null ? null : this.innerProperties().query();
    }

    /**
     * Set the query property: KQL query that will be graph.
     * 
     * @param query the query value to set.
     * @return the GraphQueryUpdateParameters object itself.
     */
    public GraphQueryUpdateParameters withQuery(String query) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GraphQueryPropertiesUpdateParameters();
        }
        this.innerProperties().withQuery(query);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GraphQueryUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GraphQueryUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GraphQueryUpdateParameters.
     */
    public static GraphQueryUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GraphQueryUpdateParameters deserializedGraphQueryUpdateParameters = new GraphQueryUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGraphQueryUpdateParameters.tags = tags;
                } else if ("etag".equals(fieldName)) {
                    deserializedGraphQueryUpdateParameters.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedGraphQueryUpdateParameters.innerProperties
                        = GraphQueryPropertiesUpdateParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGraphQueryUpdateParameters;
        });
    }
}
