// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a query to be executed.
 */
@Fluent
public final class QueryRequest implements JsonSerializable<QueryRequest> {
    /*
     * Azure subscriptions against which to execute the query.
     */
    private List<String> subscriptions;

    /*
     * Azure management groups against which to execute the query. Example: [ 'mg1', 'mg2' ]
     */
    private List<String> managementGroups;

    /*
     * The resources query.
     */
    private String query;

    /*
     * The query evaluation options
     */
    private QueryRequestOptions options;

    /*
     * An array of facet requests to be computed against the query result.
     */
    private List<FacetRequest> facets;

    /**
     * Creates an instance of QueryRequest class.
     */
    public QueryRequest() {
    }

    /**
     * Get the subscriptions property: Azure subscriptions against which to execute the query.
     * 
     * @return the subscriptions value.
     */
    public List<String> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: Azure subscriptions against which to execute the query.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest withSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the managementGroups property: Azure management groups against which to execute the query. Example: [ 'mg1',
     * 'mg2' ].
     * 
     * @return the managementGroups value.
     */
    public List<String> managementGroups() {
        return this.managementGroups;
    }

    /**
     * Set the managementGroups property: Azure management groups against which to execute the query. Example: [ 'mg1',
     * 'mg2' ].
     * 
     * @param managementGroups the managementGroups value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest withManagementGroups(List<String> managementGroups) {
        this.managementGroups = managementGroups;
        return this;
    }

    /**
     * Get the query property: The resources query.
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: The resources query.
     * 
     * @param query the query value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the options property: The query evaluation options.
     * 
     * @return the options value.
     */
    public QueryRequestOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The query evaluation options.
     * 
     * @param options the options value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest withOptions(QueryRequestOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Get the facets property: An array of facet requests to be computed against the query result.
     * 
     * @return the facets value.
     */
    public List<FacetRequest> facets() {
        return this.facets;
    }

    /**
     * Set the facets property: An array of facet requests to be computed against the query result.
     * 
     * @param facets the facets value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest withFacets(List<FacetRequest> facets) {
        this.facets = facets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (query() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property query in model QueryRequest"));
        }
        if (options() != null) {
            options().validate();
        }
        if (facets() != null) {
            facets().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(QueryRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeArrayField("subscriptions", this.subscriptions,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("managementGroups", this.managementGroups,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("options", this.options);
        jsonWriter.writeArrayField("facets", this.facets, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the QueryRequest.
     */
    public static QueryRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryRequest deserializedQueryRequest = new QueryRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("query".equals(fieldName)) {
                    deserializedQueryRequest.query = reader.getString();
                } else if ("subscriptions".equals(fieldName)) {
                    List<String> subscriptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedQueryRequest.subscriptions = subscriptions;
                } else if ("managementGroups".equals(fieldName)) {
                    List<String> managementGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedQueryRequest.managementGroups = managementGroups;
                } else if ("options".equals(fieldName)) {
                    deserializedQueryRequest.options = QueryRequestOptions.fromJson(reader);
                } else if ("facets".equals(fieldName)) {
                    List<FacetRequest> facets = reader.readArray(reader1 -> FacetRequest.fromJson(reader1));
                    deserializedQueryRequest.facets = facets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryRequest;
        });
    }
}
