// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

/**
 * Defines in which format query result returned.
 */
public enum ResultFormat {
    /**
     * Enum value table.
     */
    TABLE("table"),

    /**
     * Enum value objectArray.
     */
    OBJECT_ARRAY("objectArray");

    /**
     * The actual serialized value for a ResultFormat instance.
     */
    private final String value;

    ResultFormat(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResultFormat instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResultFormat object, or null if unable to parse.
     */
    public static ResultFormat fromString(String value) {
        if (value == null) {
            return null;
        }
        ResultFormat[] items = ResultFormat.values();
        for (ResultFormat item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
