/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ManagedByTenant;
import com.azure.resourcemanager.resources.models.SubscriptionPolicies;
import com.azure.resourcemanager.resources.models.SubscriptionState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class SubscriptionInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SubscriptionInner.class);
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="subscriptionId", access=JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;
    @JsonProperty(value="displayName", access=JsonProperty.Access.WRITE_ONLY)
    private String displayName;
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private SubscriptionState state;
    @JsonProperty(value="subscriptionPolicies")
    private SubscriptionPolicies subscriptionPolicies;
    @JsonProperty(value="authorizationSource")
    private String authorizationSource;
    @JsonProperty(value="managedByTenants")
    private List<ManagedByTenant> managedByTenants;
    @JsonProperty(value="tags")
    private Map<String, String> tags;

    public String id() {
        return this.id;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String displayName() {
        return this.displayName;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public SubscriptionState state() {
        return this.state;
    }

    public SubscriptionPolicies subscriptionPolicies() {
        return this.subscriptionPolicies;
    }

    public SubscriptionInner withSubscriptionPolicies(SubscriptionPolicies subscriptionPolicies) {
        this.subscriptionPolicies = subscriptionPolicies;
        return this;
    }

    public String authorizationSource() {
        return this.authorizationSource;
    }

    public SubscriptionInner withAuthorizationSource(String authorizationSource) {
        this.authorizationSource = authorizationSource;
        return this;
    }

    public List<ManagedByTenant> managedByTenants() {
        return this.managedByTenants;
    }

    public SubscriptionInner withManagedByTenants(List<ManagedByTenant> managedByTenants) {
        this.managedByTenants = managedByTenants;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SubscriptionInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.subscriptionPolicies() != null) {
            this.subscriptionPolicies().validate();
        }
        if (this.managedByTenants() != null) {
            this.managedByTenants().forEach(e -> e.validate());
        }
    }
}

