/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReturnRequestIdHeaderPolicy
implements HttpPipelinePolicy {
    private static final String NAME_RETURN_CLIENT_REQUEST_ID = "x-ms-return-client-request-id";
    private static final String NAME_CLIENT_REQUEST_ID = "x-ms-client-request-id";
    private final Option option;

    public ReturnRequestIdHeaderPolicy() {
        this(Option.NONE);
    }

    public ReturnRequestIdHeaderPolicy(Option option) {
        this.option = option;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest request = context.getHttpRequest();
        String clientRequestId = request.getHeaders().getValue(NAME_CLIENT_REQUEST_ID);
        if (request.getHeaders().getValue(NAME_RETURN_CLIENT_REQUEST_ID) == null) {
            request.getHeaders().put(NAME_RETURN_CLIENT_REQUEST_ID, "true");
        }
        Mono responseMono = next.process();
        if (this.option == Option.COPY_CLIENT_REQUEST_ID && clientRequestId != null) {
            responseMono = responseMono.map(response -> {
                if (response.getHeaderValue(NAME_CLIENT_REQUEST_ID) == null) {
                    response = new BufferedHttpHeaderResponse((HttpResponse)response);
                    response.getHeaders().put(NAME_CLIENT_REQUEST_ID, clientRequestId);
                }
                return response;
            });
        }
        return responseMono;
    }

    private static class BufferedHttpHeaderResponse
    extends HttpResponse {
        private final HttpResponse innerHttpResponse;
        private final HttpHeaders cachedHeaders;

        BufferedHttpHeaderResponse(HttpResponse innerHttpResponse) {
            super(innerHttpResponse.getRequest());
            this.innerHttpResponse = innerHttpResponse;
            this.cachedHeaders = new HttpHeaders((Iterable)innerHttpResponse.getHeaders());
        }

        public int getStatusCode() {
            return this.innerHttpResponse.getStatusCode();
        }

        public String getHeaderValue(String name) {
            return this.cachedHeaders.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.cachedHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return this.innerHttpResponse.getBody();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return this.innerHttpResponse.getBodyAsByteArray();
        }

        public Mono<String> getBodyAsString() {
            return this.innerHttpResponse.getBodyAsString();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return this.innerHttpResponse.getBodyAsString();
        }
    }

    public static enum Option {
        NONE,
        COPY_CLIENT_REQUEST_ID;

    }
}

