/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.DeploymentsClient;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.SupportsGettingByResourceGroupImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.implementation.DeploymentImpl;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.Deployments;
import reactor.core.publisher.Mono;

public final class DeploymentsImpl
extends SupportsGettingByResourceGroupImpl<Deployment>
implements Deployments,
HasManager<ResourceManager> {
    private final ResourceManager resourceManager;

    public DeploymentsImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public PagedIterable<Deployment> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<Deployment> listByResourceGroup(String groupName) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().listByResourceGroup(groupName).mapPage(inner -> this.createFluentModel((DeploymentExtendedInner)((Object)inner)));
    }

    @Override
    public Deployment getByName(String name) {
        return (Deployment)this.getByNameAsync(name).block();
    }

    @Override
    public Mono<Deployment> getByNameAsync(String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().getAtTenantScopeAsync(name).map(inner -> new DeploymentImpl((DeploymentExtendedInner)((Object)inner), inner.name(), this.resourceManager));
    }

    @Override
    public Mono<Deployment> getByResourceGroupAsync(String groupName, String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().getByResourceGroupAsync(groupName, name).map(deploymentExtendedInner -> {
            if (deploymentExtendedInner != null) {
                return this.createFluentModel((DeploymentExtendedInner)((Object)deploymentExtendedInner));
            }
            return null;
        });
    }

    @Override
    public void deleteByResourceGroup(String groupName, String name) {
        this.deleteByResourceGroupAsync(groupName, name).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String groupName, String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().deleteAsync(groupName, name);
    }

    @Override
    public DeploymentImpl define(String name) {
        return this.createFluentModel(name);
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().checkExistence(resourceGroupName, deploymentName);
    }

    protected DeploymentImpl createFluentModel(String name) {
        return new DeploymentImpl(new DeploymentExtendedInner(), name, this.resourceManager);
    }

    protected DeploymentImpl createFluentModel(DeploymentExtendedInner deploymentExtendedInner) {
        return new DeploymentImpl(deploymentExtendedInner, deploymentExtendedInner.name(), this.resourceManager);
    }

    @Override
    public Deployment getById(String id) {
        return (Deployment)this.getByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByResourceGroupAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    @Override
    public PagedFlux<Deployment> listAsync() {
        return PagedConverter.mergePagedFlux(this.manager().resourceGroups().listAsync(), resourceGroup -> this.listByResourceGroupAsync(resourceGroup.name()));
    }

    @Override
    public PagedFlux<Deployment> listByResourceGroupAsync(String resourceGroupName) {
        DeploymentsClient client = ((ResourceManagementClient)this.manager().serviceClient()).getDeployments();
        return client.listByResourceGroupAsync(resourceGroupName).mapPage(deploymentExtendedInner -> this.createFluentModel((DeploymentExtendedInner)((Object)deploymentExtendedInner)));
    }
}

