/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.PolicyAssignmentsClient;
import com.azure.resourcemanager.resources.fluent.PolicyClient;
import com.azure.resourcemanager.resources.fluent.PolicyDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.PolicySetDefinitionsClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.resources.implementation.PolicyAssignmentsClientImpl;
import com.azure.resourcemanager.resources.implementation.PolicyDefinitionsClientImpl;
import com.azure.resourcemanager.resources.implementation.PolicySetDefinitionsClientImpl;
import java.time.Duration;

public final class PolicyClientImpl
extends AzureServiceClient
implements PolicyClient {
    private final ClientLogger logger = new ClientLogger(PolicyClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final PolicyAssignmentsClient policyAssignments;
    private final PolicyDefinitionsClient policyDefinitions;
    private final PolicySetDefinitionsClient policySetDefinitions;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public PolicyAssignmentsClient getPolicyAssignments() {
        return this.policyAssignments;
    }

    @Override
    public PolicyDefinitionsClient getPolicyDefinitions() {
        return this.policyDefinitions;
    }

    @Override
    public PolicySetDefinitionsClient getPolicySetDefinitions() {
        return this.policySetDefinitions;
    }

    PolicyClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2019-09-01";
        this.policyAssignments = new PolicyAssignmentsClientImpl(this);
        this.policyDefinitions = new PolicyDefinitionsClientImpl(this);
        this.policySetDefinitions = new PolicySetDefinitionsClientImpl(this);
    }
}

