/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.PairedRegion;
import com.azure.resourcemanager.resources.models.RegionCategory;
import com.azure.resourcemanager.resources.models.RegionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LocationMetadata {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocationMetadata.class);
    @JsonProperty(value="regionType", access=JsonProperty.Access.WRITE_ONLY)
    private RegionType regionType;
    @JsonProperty(value="regionCategory", access=JsonProperty.Access.WRITE_ONLY)
    private RegionCategory regionCategory;
    @JsonProperty(value="geographyGroup", access=JsonProperty.Access.WRITE_ONLY)
    private String geographyGroup;
    @JsonProperty(value="longitude", access=JsonProperty.Access.WRITE_ONLY)
    private String longitude;
    @JsonProperty(value="latitude", access=JsonProperty.Access.WRITE_ONLY)
    private String latitude;
    @JsonProperty(value="physicalLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String physicalLocation;
    @JsonProperty(value="pairedRegion")
    private List<PairedRegion> pairedRegion;

    public RegionType regionType() {
        return this.regionType;
    }

    public RegionCategory regionCategory() {
        return this.regionCategory;
    }

    public String geographyGroup() {
        return this.geographyGroup;
    }

    public String longitude() {
        return this.longitude;
    }

    public String latitude() {
        return this.latitude;
    }

    public String physicalLocation() {
        return this.physicalLocation;
    }

    public List<PairedRegion> pairedRegion() {
        return this.pairedRegion;
    }

    public LocationMetadata withPairedRegion(List<PairedRegion> pairedRegion) {
        this.pairedRegion = pairedRegion;
        return this;
    }

    public void validate() {
        if (this.pairedRegion() != null) {
            this.pairedRegion().forEach(e -> e.validate());
        }
    }
}

