/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsDeletingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingById;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

public abstract class GroupableResourcesImpl<T extends GroupableResource<ManagerT, InnerT>, ImplT extends T, InnerT extends Resource, InnerCollectionT, ManagerT extends Manager<?>>
extends CreatableResourcesImpl<T, ImplT, InnerT>
implements SupportsGettingById<T>,
SupportsGettingByResourceGroup<T>,
SupportsDeletingByResourceGroup,
HasManager<ManagerT> {
    private final InnerCollectionT innerCollection;
    private final ManagerT myManager;

    protected GroupableResourcesImpl(InnerCollectionT innerCollection, ManagerT manager) {
        this.innerCollection = innerCollection;
        this.myManager = manager;
    }

    public InnerCollectionT inner() {
        return this.innerCollection;
    }

    @Override
    public ManagerT manager() {
        return this.myManager;
    }

    @Override
    public T getById(String id) {
        return (T)((GroupableResource)this.getByIdAsync(id).block());
    }

    @Override
    public final Mono<T> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        return this.getByResourceGroupAsync(resourceId.resourceGroupName(), resourceId.name());
    }

    @Override
    public final void deleteByResourceGroup(String groupName, String name) {
        this.deleteByResourceGroupAsync(groupName, name).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String groupName, String name) {
        return this.deleteInnerAsync(groupName, name).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByResourceGroupAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public T getByResourceGroup(String resourceGroupName, String name) {
        return (T)((GroupableResource)this.getByResourceGroupAsync(resourceGroupName, name).block());
    }

    @Override
    public Mono<T> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getInnerAsync(resourceGroupName, name).map(this::wrapModel);
    }

    protected abstract Mono<InnerT> getInnerAsync(String var1, String var2);

    protected abstract Mono<Void> deleteInnerAsync(String var1, String var2);
}

