/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsBatchDeletion;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsListingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class TopLevelModifiableResourcesImpl<T extends GroupableResource<ManagerT, InnerT>, ImplT extends T, InnerT extends Resource, InnerCollectionT extends InnerSupportsListing<InnerT> & InnerSupportsGet<InnerT>, ManagerT extends Manager<?>>
extends GroupableResourcesImpl<T, ImplT, InnerT, InnerCollectionT, ManagerT>
implements SupportsListing<T>,
SupportsListingByResourceGroup<T>,
SupportsBatchDeletion {
    protected TopLevelModifiableResourcesImpl(InnerCollectionT innerCollection, ManagerT manager) {
        super(innerCollection, manager);
    }

    @Override
    protected final Mono<InnerT> getInnerAsync(String resourceGroupName, String name) {
        return ((InnerSupportsGet)((Object)((InnerSupportsListing)this.inner()))).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((InnerSupportsDelete)((Object)((InnerSupportsListing)this.inner()))).deleteAsync(resourceGroupName, name).then();
    }

    @Override
    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).blockLast();
        }
    }

    @Override
    public PagedFlux<T> listAsync() {
        return this.wrapPageAsync(((InnerSupportsListing)this.inner()).listAsync());
    }

    @Override
    public PagedFlux<T> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((InnerSupportsListing)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<T> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<T> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }
}

