/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.utils;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.provider.DelayProvider;
import com.azure.core.management.provider.IdentifierProvider;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceDelayProvider;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceNamer;
import com.azure.resourcemanager.resources.models.Subscription;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ResourceManagerUtils {
    private ResourceManagerUtils() {
    }

    public static boolean toPrimitiveBoolean(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    public static int toPrimitiveInt(Integer value) {
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static int toPrimitiveInt(Long value) {
        if (value == null) {
            return 0;
        }
        return Math.toIntExact(value);
    }

    public static long toPrimitiveLong(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(InternalRuntimeContext.getDelayDuration(duration).toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String createOdataFilterForTags(String tagName, String tagValue) {
        if (tagName == null) {
            return null;
        }
        if (tagValue == null) {
            return String.format("tagname eq '%s'", tagName);
        }
        return String.format("tagname eq '%s' and tagvalue eq '%s'", tagName, tagValue);
    }

    public static String getDefaultSubscription(PagedIterable<Subscription> subscriptions) {
        ArrayList subscriptionList = new ArrayList();
        subscriptions.forEach(subscription -> subscriptionList.add(subscription));
        if (subscriptionList.size() == 0) {
            throw new ClientLogger(ResourceManagerUtils.class).logExceptionAsError((RuntimeException)new IllegalStateException("Please create a subscription before you start resource management. To learn more, see: https://azure.microsoft.com/en-us/free/."));
        }
        if (subscriptionList.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("More than one subscription found in your tenant. Please specify which one below is desired for resource management.");
            subscriptionList.forEach(subscription -> stringBuilder.append("\n" + subscription.displayName() + " : " + subscription.subscriptionId()));
            throw new ClientLogger(ResourceManagerUtils.class).logExceptionAsError((RuntimeException)new IllegalStateException(stringBuilder.toString()));
        }
        return ((Subscription)subscriptionList.get(0)).subscriptionId();
    }

    public static String getDefaultScopeFromRequest(HttpRequest request, AzureEnvironment environment) {
        return ResourceManagerUtils.getDefaultScopeFromUrl(request.getUrl().toString().toLowerCase(Locale.ROOT), environment);
    }

    static String getDefaultScopeFromUrl(String url, AzureEnvironment environment) {
        String resource = environment.getManagementEndpoint();
        for (Map.Entry endpoint : environment.getEndpoints().entrySet()) {
            if (!url.contains((CharSequence)endpoint.getValue())) continue;
            if (((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.KEYVAULT.identifier())) {
                resource = String.format("https://%s/", ((String)endpoint.getValue()).replaceAll("^\\.*", ""));
                break;
            }
            if (((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.GRAPH.identifier())) {
                resource = environment.getGraphEndpoint();
                break;
            }
            if (((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.LOG_ANALYTICS.identifier())) {
                resource = environment.getLogAnalyticsEndpoint();
                break;
            }
            if (((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.APPLICATION_INSIGHTS.identifier())) {
                resource = environment.getApplicationInsightsEndpoint();
                break;
            }
            if (!((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.DATA_LAKE_STORE.identifier()) && !((String)endpoint.getKey()).equals(AzureEnvironment.Endpoint.DATA_LAKE_ANALYTICS.identifier())) continue;
            resource = environment.getDataLakeEndpointResourceId();
            break;
        }
        return ResourceManagerUtils.removeTrailingSlash(resource) + "/.default";
    }

    private static String removeTrailingSlash(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getStorageConnectionString(String accountName, String accountKey, AzureEnvironment environment) {
        if (environment == null || environment.getStorageEndpointSuffix() == null) {
            environment = AzureEnvironment.AZURE;
        }
        String suffix = environment.getStorageEndpointSuffix().replaceAll("^\\.*", "");
        return String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=%s", accountName, accountKey, suffix);
    }

    public static class InternalRuntimeContext {
        private Function<String, IdentifierProvider> identifierFunction = ResourceNamer::new;
        private static DelayProvider delayProvider = new ResourceDelayProvider();
        private static Scheduler reactorScheduler = Schedulers.parallel();

        public void setIdentifierFunction(Function<String, IdentifierProvider> identifierFunction) {
            this.identifierFunction = identifierFunction;
        }

        public IdentifierProvider createIdentifierProvider(String name) {
            return this.identifierFunction.apply(name);
        }

        public String randomResourceName(String prefix, int maxLen) {
            return this.identifierFunction.apply("").getRandomName(prefix, maxLen);
        }

        public String randomUuid() {
            return this.identifierFunction.apply("").getRandomUuid();
        }

        public static void setDelayProvider(DelayProvider delayProvider) {
            InternalRuntimeContext.delayProvider = delayProvider;
        }

        public static Duration getDelayDuration(Duration delay) {
            return delayProvider.getDelayDuration(delay);
        }

        public static Scheduler getReactorScheduler() {
            return reactorScheduler;
        }

        public static void setReactorScheduler(Scheduler reactorScheduler) {
            InternalRuntimeContext.reactorScheduler = reactorScheduler;
        }
    }
}

