/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluent.SubscriptionsClient;
import com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.SupportsGettingByIdImpl;
import com.azure.resourcemanager.resources.implementation.SubscriptionImpl;
import com.azure.resourcemanager.resources.models.Subscription;
import com.azure.resourcemanager.resources.models.Subscriptions;
import reactor.core.publisher.Mono;

public final class SubscriptionsImpl
extends SupportsGettingByIdImpl<Subscription>
implements Subscriptions {
    private final SubscriptionsClient client;

    public SubscriptionsImpl(SubscriptionsClient client) {
        this.client = client;
    }

    @Override
    public PagedIterable<Subscription> list() {
        return this.client.list().mapPage(inner -> this.wrapModel((SubscriptionInner)inner));
    }

    @Override
    public Mono<Subscription> getByIdAsync(String id) {
        return this.client.getAsync(id).map(inner -> this.wrapModel((SubscriptionInner)inner));
    }

    @Override
    public PagedFlux<Subscription> listAsync() {
        return this.client.listAsync().mapPage(inner -> this.wrapModel((SubscriptionInner)inner));
    }

    private SubscriptionImpl wrapModel(SubscriptionInner subscriptionInner) {
        if (subscriptionInner == null) {
            return null;
        }
        return new SubscriptionImpl(subscriptionInner, this.client);
    }
}

