/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasName;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.resources.models.Dependency;
import com.azure.resourcemanager.resources.models.DeploymentExportResult;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentOperations;
import com.azure.resourcemanager.resources.models.ParametersLink;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.TemplateLink;
import com.azure.resourcemanager.resources.models.WhatIfOperationResult;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import reactor.core.publisher.Mono;

public interface Deployment
extends Indexable,
Refreshable<Deployment>,
Updatable<Update>,
HasInnerModel<DeploymentExtendedInner>,
HasManager<ResourceManager>,
HasName,
HasId {
    public String resourceGroupName();

    public String provisioningState();

    public String correlationId();

    public OffsetDateTime timestamp();

    public Object outputs();

    public List<Provider> providers();

    public List<Dependency> dependencies();

    public String templateHash();

    public TemplateLink templateLink();

    public Object parameters();

    public ParametersLink parametersLink();

    public DeploymentMode mode();

    public List<ResourceReference> outputResources();

    public DeploymentOperations deploymentOperations();

    public void cancel();

    public Mono<Void> cancelAsync();

    public DeploymentExportResult exportTemplate();

    public Mono<DeploymentExportResult> exportTemplateAsync();

    public Execution prepareWhatIf();

    public static interface ExecutionStages {

        public static interface WithExecute {
            public WhatIfOperationResult whatIf();

            public Mono<WhatIfOperationResult> whatIfAsync();

            public WhatIfOperationResult whatIfAtSubscriptionScope();

            public Mono<WhatIfOperationResult> whatIfAtSubscriptionScopeAsync();
        }

        public static interface WithWhatIfOnErrorDeploymentType {
            public WithWhatIf withLastSuccessfulOnErrorDeployment();

            public WithWhatIf withSpecialDeploymentOnErrorDeployment();
        }

        public static interface WithWhatIfParameter {
            public WithWhatIf withWhatIfParameters(Object var1);

            public WithWhatIf withWhatIfParametersLink(String var1, String var2);
        }

        public static interface WithWhatIfTemplate {
            public WithWhatIf withWhatIfTemplate(Object var1);

            public WithWhatIf withWhatIfTemplateLink(String var1, String var2);
        }

        public static interface WithWhatIfResultFormat {
            public WithWhatIf withFullResourcePayloadsResultFormat();

            public WithWhatIf withResourceIdOnlyResultFormat();
        }

        public static interface WithWhatIfDeploymentMode {
            public WithWhatIf withIncrementalMode();

            public WithWhatIf withCompleteMode();
        }

        public static interface WithWhatIfLocation {
            public WithWhatIf withLocation(String var1);
        }

        public static interface WithWhatIf
        extends WithExecute,
        WithWhatIfDeploymentMode,
        WithWhatIfLocation,
        WithWhatIfOnErrorDeploymentType,
        WithWhatIfParameter,
        WithWhatIfResultFormat,
        WithWhatIfTemplate {
            public WithWhatIf withDetailedLevel(String var1);

            public WithWhatIf withDeploymentName(String var1);
        }

        public static interface Blank {
        }
    }

    public static interface Execution
    extends ExecutionStages.Blank,
    ExecutionStages.WithExecute,
    ExecutionStages.WithWhatIf,
    ExecutionStages.WithWhatIfDeploymentMode,
    ExecutionStages.WithWhatIfLocation,
    ExecutionStages.WithWhatIfOnErrorDeploymentType,
    ExecutionStages.WithWhatIfParameter,
    ExecutionStages.WithWhatIfResultFormat,
    ExecutionStages.WithWhatIfTemplate {
    }

    public static interface Update
    extends Appliable<Deployment>,
    UpdateStages.WithTemplate,
    UpdateStages.WithParameters,
    UpdateStages.WithMode {
    }

    public static interface UpdateStages {

        public static interface WithParameters {
            public Update withParameters(Object var1);

            public Update withParameters(String var1) throws IOException;

            public Update withParametersLink(String var1, String var2);
        }

        public static interface WithTemplate {
            public Update withTemplate(Object var1);

            public Update withTemplate(String var1) throws IOException;

            public Update withTemplateLink(String var1, String var2);
        }

        public static interface WithMode {
            public Update withMode(DeploymentMode var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Deployment> {
            public Accepted<Deployment> beginCreate();

            public Mono<Deployment> beginCreateAsync();
        }

        public static interface WithMode {
            public WithCreate withMode(DeploymentMode var1);
        }

        public static interface WithParameters {
            public WithMode withParameters(Object var1);

            public WithMode withParameters(String var1) throws IOException;

            public WithMode withParametersLink(String var1, String var2);
        }

        public static interface WithTemplate {
            public WithParameters withTemplate(Object var1);

            public WithParameters withTemplate(String var1) throws IOException;

            public WithParameters withTemplateLink(String var1, String var2);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithExistingResourceGroup<WithTemplate> {
            public WithTemplate withNewResourceGroup(String var1, Region var2);

            public WithTemplate withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface Blank
        extends WithGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithTemplate,
    DefinitionStages.WithParameters,
    DefinitionStages.WithMode,
    DefinitionStages.WithCreate {
    }
}

