// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.CheckResourceNameResultInner;
import com.azure.resourcemanager.resources.models.ResourceName;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ResourceNamesClient. */
public interface ResourceNamesClient {
    /**
     * A resource name is valid if it is not a reserved word, does not contains a reserved word and does not start with
     * a reserved word.
     *
     * @param resourceNameDefinition Resource object with values for resource name and resource type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource Name valid if not a reserved word, does not contain a reserved word and does not start with a
     *     reserved word.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CheckResourceNameResultInner>> checkResourceNameWithResponseAsync(
        ResourceName resourceNameDefinition);

    /**
     * A resource name is valid if it is not a reserved word, does not contains a reserved word and does not start with
     * a reserved word.
     *
     * @param resourceNameDefinition Resource object with values for resource name and resource type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource Name valid if not a reserved word, does not contain a reserved word and does not start with a
     *     reserved word.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckResourceNameResultInner> checkResourceNameAsync(ResourceName resourceNameDefinition);

    /**
     * A resource name is valid if it is not a reserved word, does not contains a reserved word and does not start with
     * a reserved word.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource Name valid if not a reserved word, does not contain a reserved word and does not start with a
     *     reserved word.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckResourceNameResultInner> checkResourceNameAsync();

    /**
     * A resource name is valid if it is not a reserved word, does not contains a reserved word and does not start with
     * a reserved word.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource Name valid if not a reserved word, does not contain a reserved word and does not start with a
     *     reserved word.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckResourceNameResultInner checkResourceName();

    /**
     * A resource name is valid if it is not a reserved word, does not contains a reserved word and does not start with
     * a reserved word.
     *
     * @param resourceNameDefinition Resource object with values for resource name and resource type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource Name valid if not a reserved word, does not contain a reserved word and does not start with a
     *     reserved word.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckResourceNameResultInner> checkResourceNameWithResponse(
        ResourceName resourceNameDefinition, Context context);
}
