// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluent.ResourcesClient;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceExpandedInner;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.ResourceListResult;
import com.azure.resourcemanager.resources.models.ResourcesMoveInfo;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ResourcesClient. */
public final class ResourcesClientImpl implements InnerSupportsListing<GenericResourceExpandedInner>, ResourcesClient {
    private final ClientLogger logger = new ClientLogger(ResourcesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ResourcesService service;

    /** The service client containing this operation class. */
    private final ResourceManagementClientImpl client;

    /**
     * Initializes an instance of ResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ResourcesClientImpl(ResourceManagementClientImpl client) {
        this.service =
            RestProxy.create(ResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ResourceManagementClientResources to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ResourceManagementCl")
    private interface ResourcesService {
        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("$filter") String filter,
            @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> moveResources(
            @HostParam("$host") String endpoint,
            @PathParam("sourceResourceGroupName") String sourceResourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ResourcesMoveInfo parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateMoveResources(
            @HostParam("$host") String endpoint,
            @PathParam("sourceResourceGroupName") String sourceResourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ResourcesMoveInfo parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/resources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter,
            @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Head(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses({204, 404})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistence(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") GenericResourceInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") GenericResourceInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GenericResourceInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Head("/{resourceId}")
        @ExpectedResponses({204, 404})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistenceById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "resourceId", encoded = true) String resourceId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/{resourceId}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "resourceId", encoded = true) String resourceId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/{resourceId}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "resourceId", encoded = true) String resourceId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GenericResourceInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/{resourceId}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "resourceId", encoded = true) String resourceId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GenericResourceInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{resourceId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GenericResourceInner>> getById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "resourceId", encoded = true) String resourceId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            filter,
                            expand,
                            top,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<GenericResourceExpandedInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                filter,
                expand,
                top,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(
        String resourceGroupName, String filter, String expand, Integer top) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        final String expand = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(
        String resourceGroupName, String filter, String expand, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        final String expand = null;
        final Integer top = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, expand, top));
    }

    /**
     * Get all the resources for a resource group.
     *
     * @param resourceGroupName The resource group with the resources to get.
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> listByResourceGroup(
        String resourceGroupName, String filter, String expand, Integer top, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, expand, top, context));
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> moveResourcesWithResponseAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .moveResources(
                            this.client.getEndpoint(),
                            sourceResourceGroupName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> moveResourcesWithResponseAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .moveResources(
                this.client.getEndpoint(),
                sourceResourceGroupName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginMoveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = moveResourcesWithResponseAsync(sourceResourceGroupName, parameters);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginMoveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            moveResourcesWithResponseAsync(sourceResourceGroupName, parameters, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginMoveResources(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return beginMoveResourcesAsync(sourceResourceGroupName, parameters).getSyncPoller();
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginMoveResources(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return beginMoveResourcesAsync(sourceResourceGroupName, parameters, context).getSyncPoller();
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> moveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return beginMoveResourcesAsync(sourceResourceGroupName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> moveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return beginMoveResourcesAsync(sourceResourceGroupName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        moveResourcesAsync(sourceResourceGroupName, parameters).block();
    }

    /**
     * The resources to move must be in the same source resource group. The target resource group may be in a different
     * subscription. When moving resources, both the source group and the target group are locked for the duration of
     * the operation. Write and delete operations are blocked on the groups until the move completes.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        moveResourcesAsync(sourceResourceGroupName, parameters, context).block();
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateMoveResourcesWithResponseAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .validateMoveResources(
                            this.client.getEndpoint(),
                            sourceResourceGroupName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateMoveResourcesWithResponseAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .validateMoveResources(
                this.client.getEndpoint(),
                sourceResourceGroupName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginValidateMoveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            validateMoveResourcesWithResponseAsync(sourceResourceGroupName, parameters);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginValidateMoveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            validateMoveResourcesWithResponseAsync(sourceResourceGroupName, parameters, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateMoveResources(
        String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters).getSyncPoller();
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginValidateMoveResources(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters, context).getSyncPoller();
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> validateMoveResourcesAsync(
        String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        validateMoveResourcesAsync(sourceResourceGroupName, parameters).block();
    }

    /**
     * This operation checks whether the specified resources can be moved to the target. The resources to move must be
     * in the same source resource group. The target resource group may be in a different subscription. If validation
     * succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409
     * (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the
     * long-running operation.
     *
     * @param sourceResourceGroupName The name of the resource group containing the resources to validate for move.
     * @param parameters Parameters for moving resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        validateMoveResourcesAsync(sourceResourceGroupName, parameters, context).block();
    }

    /**
     * Get all the resources in a subscription.
     *
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listSinglePageAsync(
        String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            filter,
                            expand,
                            top,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<GenericResourceExpandedInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listSinglePageAsync(
        String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                filter,
                expand,
                top,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listAsync(String filter, String expand, Integer top) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, expand, top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listAsync() {
        final String filter = null;
        final String expand = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, expand, top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GenericResourceExpandedInner> listAsync(
        String filter, String expand, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, expand, top, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> list() {
        final String filter = null;
        final String expand = null;
        final Integer top = null;
        return new PagedIterable<>(listAsync(filter, expand, top));
    }

    /**
     * Get all the resources in a subscription.
     *
     * @param filter The filter to apply on the operation.&lt;br&gt;&lt;br&gt;The properties you can use for eq (equals)
     *     or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan,
     *     plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.&lt;br&gt;&lt;br&gt;For
     *     example, to filter by a resource type, use: $filter=resourceType eq
     *     'Microsoft.Network/virtualNetworks'&lt;br&gt;&lt;br&gt;You can use substringof(value, property) in the
     *     filter. The properties you can use for substring are: name and resourceGroup.&lt;br&gt;&lt;br&gt;For example,
     *     to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo',
     *     name)&lt;br&gt;&lt;br&gt;You can link more than one substringof together by adding and/or
     *     operators.&lt;br&gt;&lt;br&gt;You can filter by tag names and values. For example, to filter for a tag name
     *     and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
     *     the tags for each resource are not returned in the results.&lt;br&gt;&lt;br&gt;You can use some properties
     *     together when filtering. The combinations you can use are: substringof and/or resourceType, plan and
     *     plan/publisher and plan/name, identity and identity/principalId.
     * @param expand Comma-separated list of additional properties to be included in the response. Valid values include
     *     `createdTime`, `changedTime` and `provisioningState`. For example, `$expand=createdTime,changedTime`.
     * @param top The number of results to return. If null is passed, returns all resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the resources in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> list(
        String filter, String expand, Integer top, Context context) {
        return new PagedIterable<>(listAsync(filter, expand, top, context));
    }

    /**
     * Checks whether a resource exists.
     *
     * @param resourceGroupName The name of the resource group containing the resource to check. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The resource provider of the resource to check.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to check whether it exists.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .checkExistence(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether a resource exists.
     *
     * @param resourceGroupName The name of the resource group containing the resource to check. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The resource provider of the resource to check.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to check whether it exists.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .checkExistence(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Checks whether a resource exists.
     *
     * @param resourceGroupName The name of the resource group containing the resource to check. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The resource provider of the resource to check.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to check whether it exists.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        return checkExistenceWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .flatMap(
                (Response<Boolean> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Checks whether a resource exists.
     *
     * @param resourceGroupName The name of the resource group containing the resource to check. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The resource provider of the resource to check.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to check whether it exists.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistence(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        Boolean value =
            checkExistenceAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    apiVersion)
                .block();
        if (value != null) {
            return value;
        } else {
            throw logger.logExceptionAsError(new NullPointerException());
        }
    }

    /**
     * Checks whether a resource exists.
     *
     * @param resourceGroupName The name of the resource group containing the resource to check. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The resource provider of the resource to check.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to check whether it exists.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        return checkExistenceWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context)
            .block();
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        return beginDeleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .getSyncPoller();
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context)
            .getSyncPoller();
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        return beginDeleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        deleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .block();
    }

    /**
     * Deletes a resource.
     *
     * @param resourceGroupName The name of the resource group that contains the resource to delete. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type.
     * @param resourceName The name of the resource to delete.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        deleteAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context)
            .block();
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GenericResourceInner.class,
                GenericResourceInner.class,
                this.client.getContext());
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenericResourceInner.class, GenericResourceInner.class, context);
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .getSyncPoller();
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .getSyncPoller();
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenericResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner createOrUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return createOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .block();
    }

    /**
     * Creates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to create.
     * @param resourceName The name of the resource to create.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for creating or updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner createOrUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return createOrUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .block();
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GenericResourceInner.class,
                GenericResourceInner.class,
                this.client.getContext());
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenericResourceInner.class, GenericResourceInner.class, context);
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return beginUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .getSyncPoller();
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdate(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .getSyncPoller();
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> updateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return beginUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenericResourceInner> updateAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner update(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters) {
        return updateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters)
            .block();
    }

    /**
     * Updates a resource.
     *
     * @param resourceGroupName The name of the resource group for the resource. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to update.
     * @param resourceName The name of the resource to update.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Parameters for updating the resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner update(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        GenericResourceInner parameters,
        Context context) {
        return updateAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                parameters,
                context)
            .block();
    }

    /**
     * Gets a resource.
     *
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GenericResourceInner>> getWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a resource.
     *
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GenericResourceInner>> getWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets a resource.
     *
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> getAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        return getWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .flatMap(
                (Response<GenericResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a resource.
     *
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner get(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion) {
        return getAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion)
            .block();
    }

    /**
     * Gets a resource.
     *
     * @param resourceGroupName The name of the resource group containing the resource to get. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GenericResourceInner> getWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String apiVersion,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                context)
            .block();
    }

    /**
     * Checks by ID whether a resource exists.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.checkExistenceById(this.client.getEndpoint(), resourceId, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks by ID whether a resource exists.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceByIdWithResponseAsync(
        String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistenceById(this.client.getEndpoint(), resourceId, apiVersion, accept, context);
    }

    /**
     * Checks by ID whether a resource exists.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceByIdAsync(String resourceId, String apiVersion) {
        return checkExistenceByIdWithResponseAsync(resourceId, apiVersion)
            .flatMap(
                (Response<Boolean> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Checks by ID whether a resource exists.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistenceById(String resourceId, String apiVersion) {
        Boolean value = checkExistenceByIdAsync(resourceId, apiVersion).block();
        if (value != null) {
            return value;
        } else {
            throw logger.logExceptionAsError(new NullPointerException());
        }
    }

    /**
     * Checks by ID whether a resource exists.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceByIdWithResponse(String resourceId, String apiVersion, Context context) {
        return checkExistenceByIdWithResponseAsync(resourceId, apiVersion, context).block();
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.deleteById(this.client.getEndpoint(), resourceId, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteByIdWithResponseAsync(
        String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteById(this.client.getEndpoint(), resourceId, apiVersion, accept, context);
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteByIdAsync(String resourceId, String apiVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteByIdWithResponseAsync(resourceId, apiVersion);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteByIdAsync(
        String resourceId, String apiVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteByIdWithResponseAsync(resourceId, apiVersion, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteById(String resourceId, String apiVersion) {
        return beginDeleteByIdAsync(resourceId, apiVersion).getSyncPoller();
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteById(String resourceId, String apiVersion, Context context) {
        return beginDeleteByIdAsync(resourceId, apiVersion, context).getSyncPoller();
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteByIdAsync(String resourceId, String apiVersion) {
        return beginDeleteByIdAsync(resourceId, apiVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteByIdAsync(String resourceId, String apiVersion, Context context) {
        return beginDeleteByIdAsync(resourceId, apiVersion, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteById(String resourceId, String apiVersion) {
        deleteByIdAsync(resourceId, apiVersion).block();
    }

    /**
     * Deletes a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteById(String resourceId, String apiVersion, Context context) {
        deleteByIdAsync(resourceId, apiVersion, context).block();
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateByIdWithResponseAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdateById(
                            this.client.getEndpoint(), resourceId, apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateByIdWithResponseAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, accept, context);
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateByIdWithResponseAsync(resourceId, apiVersion, parameters);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GenericResourceInner.class,
                GenericResourceInner.class,
                this.client.getContext());
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateByIdWithResponseAsync(resourceId, apiVersion, parameters, context);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenericResourceInner.class, GenericResourceInner.class, context);
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        return beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters).getSyncPoller();
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters, context).getSyncPoller();
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> createOrUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        return beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenericResourceInner> createOrUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner createOrUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        return createOrUpdateByIdAsync(resourceId, apiVersion, parameters).block();
    }

    /**
     * Create a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Create or update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner createOrUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return createOrUpdateByIdAsync(resourceId, apiVersion, parameters, context).block();
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateByIdWithResponseAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.updateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateByIdWithResponseAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, accept, context);
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateByIdWithResponseAsync(resourceId, apiVersion, parameters);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GenericResourceInner.class,
                GenericResourceInner.class,
                this.client.getContext());
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateByIdWithResponseAsync(resourceId, apiVersion, parameters, context);
        return this
            .client
            .<GenericResourceInner, GenericResourceInner>getLroResult(
                mono, this.client.getHttpPipeline(), GenericResourceInner.class, GenericResourceInner.class, context);
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        return beginUpdateByIdAsync(resourceId, apiVersion, parameters).getSyncPoller();
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateById(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return beginUpdateByIdAsync(resourceId, apiVersion, parameters, context).getSyncPoller();
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> updateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters) {
        return beginUpdateByIdAsync(resourceId, apiVersion, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GenericResourceInner> updateByIdAsync(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return beginUpdateByIdAsync(resourceId, apiVersion, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner updateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return updateByIdAsync(resourceId, apiVersion, parameters).block();
    }

    /**
     * Updates a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param parameters Update resource parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner updateById(
        String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return updateByIdAsync(resourceId, apiVersion, parameters, context).block();
    }

    /**
     * Gets a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GenericResourceInner>> getByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getById(this.client.getEndpoint(), resourceId, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GenericResourceInner>> getByIdWithResponseAsync(
        String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getById(this.client.getEndpoint(), resourceId, apiVersion, accept, context);
    }

    /**
     * Gets a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenericResourceInner> getByIdAsync(String resourceId, String apiVersion) {
        return getByIdWithResponseAsync(resourceId, apiVersion)
            .flatMap(
                (Response<GenericResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenericResourceInner getById(String resourceId, String apiVersion) {
        return getByIdAsync(resourceId, apiVersion).block();
    }

    /**
     * Gets a resource by ID.
     *
     * @param resourceId The fully qualified ID of the resource, including the resource name and resource type. Use the
     *     format,
     *     /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
     * @param apiVersion The API version to use for the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a resource by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GenericResourceInner> getByIdWithResponse(String resourceId, String apiVersion, Context context) {
        return getByIdWithResponseAsync(resourceId, apiVersion, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of resource groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GenericResourceExpandedInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of resource groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of resource groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GenericResourceExpandedInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of resource groups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
