// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters of move resources. */
@Fluent
public final class ResourcesMoveInfo {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ResourcesMoveInfo.class);

    /*
     * The IDs of the resources.
     */
    @JsonProperty(value = "resources")
    private List<String> resources;

    /*
     * The target resource group.
     */
    @JsonProperty(value = "targetResourceGroup")
    private String targetResourceGroup;

    /**
     * Get the resources property: The IDs of the resources.
     *
     * @return the resources value.
     */
    public List<String> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: The IDs of the resources.
     *
     * @param resources the resources value to set.
     * @return the ResourcesMoveInfo object itself.
     */
    public ResourcesMoveInfo withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the targetResourceGroup property: The target resource group.
     *
     * @return the targetResourceGroup value.
     */
    public String targetResourceGroup() {
        return this.targetResourceGroup;
    }

    /**
     * Set the targetResourceGroup property: The target resource group.
     *
     * @param targetResourceGroup the targetResourceGroup value to set.
     * @return the ResourcesMoveInfo object itself.
     */
    public ResourcesMoveInfo withTargetResourceGroup(String targetResourceGroup) {
        this.targetResourceGroup = targetResourceGroup;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
