/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.policy.AuxiliaryAuthenticationPolicy;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AzureConfigurableImpl<T extends AzureConfigurable<T>>
implements AzureConfigurable<T> {
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private List<String> scopes = new ArrayList<String>();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private List<TokenCredential> tokens = new ArrayList<TokenCredential>();

    protected AzureConfigurableImpl() {
        this.retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
        this.httpLogOptions = new HttpLogOptions().setLogLevel(HttpLogDetailLevel.NONE);
    }

    @Override
    public T withLogOptions(HttpLogOptions httpLogOptions) {
        Objects.requireNonNull(httpLogOptions);
        this.httpLogOptions = httpLogOptions;
        return (T)this;
    }

    @Override
    public T withLogLevel(HttpLogDetailLevel logLevel) {
        Objects.requireNonNull(logLevel);
        this.httpLogOptions = this.httpLogOptions.setLogLevel(logLevel);
        return (T)this;
    }

    @Override
    public T withPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.policies.add(policy);
        return (T)this;
    }

    @Override
    public T withAuxiliaryCredential(TokenCredential token) {
        Objects.requireNonNull(token);
        this.tokens.add(token);
        return (T)this;
    }

    @Override
    public T withAuxiliaryCredentials(List<TokenCredential> tokens) {
        Objects.requireNonNull(tokens);
        this.tokens.addAll(tokens);
        return (T)this;
    }

    @Override
    public T withRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy);
        this.retryPolicy = retryPolicy;
        return (T)this;
    }

    @Override
    public T withScope(String scope) {
        Objects.requireNonNull(scope);
        this.scopes.add(scope);
        return (T)this;
    }

    @Override
    public T withScopes(List<String> scopes) {
        Objects.requireNonNull(scopes);
        this.scopes.addAll(scopes);
        return (T)this;
    }

    @Override
    public T withHttpClient(HttpClient httpClient) {
        Objects.requireNonNull(httpClient);
        this.httpClient = httpClient;
        return (T)this;
    }

    @Override
    public T withConfiguration(Configuration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
        return (T)this;
    }

    @Override
    public T withRetryOptions(RetryOptions retryOptions) {
        Objects.requireNonNull(retryOptions);
        this.retryOptions = retryOptions;
        return (T)this;
    }

    protected HttpPipeline buildHttpPipeline(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential);
        if (!this.tokens.isEmpty()) {
            this.policies.add(new AuxiliaryAuthenticationPolicy(profile.getEnvironment(), this.tokens.toArray(new TokenCredential[0])));
        }
        if (this.retryPolicy == null && this.retryOptions != null) {
            this.retryPolicy = new RetryPolicy(this.retryOptions);
        }
        return HttpPipelineProvider.buildHttpPipeline(credential, profile, this.scopes(), this.httpLogOptions, this.configuration, this.retryPolicy, this.policies, this.httpClient);
    }

    private String[] scopes() {
        return this.scopes.isEmpty() ? null : this.scopes.toArray(new String[0]);
    }
}

