/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.DeploymentsClient;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExportResultInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentValidateResultInner;
import com.azure.resourcemanager.resources.fluent.models.TemplateHashResultInner;
import com.azure.resourcemanager.resources.fluent.models.WhatIfOperationResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.implementation.ResourceManagementClientImpl;
import com.azure.resourcemanager.resources.models.DeploymentListResult;
import com.azure.resourcemanager.resources.models.DeploymentWhatIf;
import com.azure.resourcemanager.resources.models.ScopedDeployment;
import com.azure.resourcemanager.resources.models.ScopedDeploymentWhatIf;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DeploymentsClientImpl
implements InnerSupportsGet<DeploymentExtendedInner>,
InnerSupportsListing<DeploymentExtendedInner>,
InnerSupportsDelete<Void>,
DeploymentsClient {
    private final DeploymentsService service;
    private final ResourceManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentsClientImpl.class);

    DeploymentsClientImpl(ResourceManagementClientImpl client) {
        this.service = (DeploymentsService)RestProxy.create(DeploymentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtScopeAsync(String scope, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtScopeWithResponseAsync(scope, deploymentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtScopeAsync(String scope, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtScopeWithResponseAsync(scope, deploymentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName, Context context) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtScopeAsync(String scope, String deploymentName) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtScopeAsync(String scope, String deploymentName, Context context) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtScope(String scope, String deploymentName) {
        this.deleteAtScopeAsync(scope, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtScope(String scope, String deploymentName, Context context) {
        this.deleteAtScopeAsync(scope, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistenceAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistenceAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName) {
        return this.checkExistenceAtScopeWithResponseAsync(scope, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistenceAtScope(String scope, String deploymentName) {
        Boolean value = (Boolean)this.checkExistenceAtScopeAsync(scope, deploymentName).block();
        if (value != null) {
            return value;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return (Response)this.checkExistenceAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScopeWithResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScopeWithResponseAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtScopeWithResponseAsync(scope, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtScopeWithResponseAsync(scope, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtScopeAsync(scope, deploymentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName) {
        return this.getAtScopeWithResponseAsync(scope, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentExtendedInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner getAtScope(String scope, String deploymentName) {
        return (DeploymentExtendedInner)((Object)this.getAtScopeAsync(scope, deploymentName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return (Response)this.getAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAtScopeAsync(String scope, String deploymentName) {
        return this.cancelAtScopeWithResponseAsync(scope, deploymentName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAtScope(String scope, String deploymentName) {
        this.cancelAtScopeAsync(scope, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return (Response)this.cancelAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtScopeWithResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtScopeWithResponseAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtScopeWithResponseAsync(scope, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtScopeWithResponseAsync(scope, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)this.validateAtScopeAsync(scope, deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentValidateResultInner)this.validateAtScopeAsync(scope, deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportTemplateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName) {
        return this.exportTemplateAtScopeWithResponseAsync(scope, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DeploymentExportResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtScope(String scope, String deploymentName) {
        return (DeploymentExportResultInner)this.exportTemplateAtScopeAsync(scope, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return (Response)this.exportTemplateAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeSinglePageAsync(String scope, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtScope(this.client.getEndpoint(), scope, filter, top, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeSinglePageAsync(String scope, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtScope(this.client.getEndpoint(), scope, filter, top, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope, String filter, Integer top) {
        return new PagedFlux(() -> this.listAtScopeSinglePageAsync(scope, filter, top), nextLink -> this.listAtScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listAtScopeSinglePageAsync(scope, filter, top), nextLink -> this.listAtScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listAtScopeSinglePageAsync(scope, filter, top, context), nextLink -> this.listAtScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtScope(String scope) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAtScopeAsync(scope, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtScope(String scope, String filter, Integer top, Context context) {
        return new PagedIterable(this.listAtScopeAsync(scope, filter, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtTenantScopeAsync(String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtTenantScopeWithResponseAsync(deploymentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtTenantScopeAsync(String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtTenantScopeWithResponseAsync(deploymentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName, Context context) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtTenantScopeAsync(String deploymentName) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtTenantScopeAsync(String deploymentName, Context context) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtTenantScope(String deploymentName) {
        this.deleteAtTenantScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtTenantScope(String deploymentName, Context context) {
        this.deleteAtTenantScopeAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistenceAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistenceAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName) {
        return this.checkExistenceAtTenantScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistenceAtTenantScope(String deploymentName) {
        Boolean value = (Boolean)this.checkExistenceAtTenantScopeAsync(deploymentName).block();
        if (value != null) {
            return value;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtTenantScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.checkExistenceAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtTenantScopeAsync(deploymentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName) {
        return this.getAtTenantScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentExtendedInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner getAtTenantScope(String deploymentName) {
        return (DeploymentExtendedInner)((Object)this.getAtTenantScopeAsync(deploymentName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtTenantScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.getAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAtTenantScopeAsync(String deploymentName) {
        return this.cancelAtTenantScopeWithResponseAsync(deploymentName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAtTenantScope(String deploymentName) {
        this.cancelAtTenantScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAtTenantScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.cancelAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)this.validateAtTenantScopeAsync(deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return (DeploymentValidateResultInner)this.validateAtTenantScopeAsync(deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.whatIfAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScopeWithResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.whatIfAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)this.whatIfAtTenantScopeAsync(deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return (WhatIfOperationResultInner)this.whatIfAtTenantScopeAsync(deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportTemplateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName) {
        return this.exportTemplateAtTenantScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DeploymentExportResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtTenantScope(String deploymentName) {
        return (DeploymentExportResultInner)this.exportTemplateAtTenantScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtTenantScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.exportTemplateAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtTenantScope(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtTenantScope(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(filter, top), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(filter, top), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(filter, top, context), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtTenantScope() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAtTenantScopeAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtTenantScope(String filter, Integer top, Context context) {
        return new PagedIterable(this.listAtTenantScopeAsync(filter, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtManagementGroupScopeWithResponseAsync(groupId, deploymentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(String groupId, String deploymentName) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(String groupId, String deploymentName, Context context) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName, Context context) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroupScope(String groupId, String deploymentName) {
        this.deleteAtManagementGroupScopeAsync(groupId, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroupScope(String groupId, String deploymentName, Context context) {
        this.deleteAtManagementGroupScopeAsync(groupId, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistenceAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistenceAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.checkExistenceAtManagementGroupScopeWithResponseAsync(groupId, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistenceAtManagementGroupScope(String groupId, String deploymentName) {
        Boolean value = (Boolean)this.checkExistenceAtManagementGroupScopeAsync(groupId, deploymentName).block();
        if (value != null) {
            return value;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtManagementGroupScopeWithResponse(String groupId, String deploymentName, Context context) {
        return (Response)this.checkExistenceAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.getAtManagementGroupScopeWithResponseAsync(groupId, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentExtendedInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner getAtManagementGroupScope(String groupId, String deploymentName) {
        return (DeploymentExtendedInner)((Object)this.getAtManagementGroupScopeAsync(groupId, deploymentName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtManagementGroupScopeWithResponse(String groupId, String deploymentName, Context context) {
        return (Response)this.getAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.cancelAtManagementGroupScopeWithResponseAsync(groupId, deploymentName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAtManagementGroupScope(String groupId, String deploymentName) {
        this.cancelAtManagementGroupScopeAsync(groupId, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAtManagementGroupScopeWithResponse(String groupId, String deploymentName, Context context) {
        return (Response)this.cancelAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)this.validateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters, Context context) {
        return (DeploymentValidateResultInner)this.validateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.whatIfAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.whatIfAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)this.whatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return (WhatIfOperationResultInner)this.whatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportTemplateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.exportTemplateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DeploymentExportResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtManagementGroupScope(String groupId, String deploymentName) {
        return (DeploymentExportResultInner)this.exportTemplateAtManagementGroupScopeAsync(groupId, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeWithResponse(String groupId, String deploymentName, Context context) {
        return (Response)this.exportTemplateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeSinglePageAsync(String groupId, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtManagementGroupScope(this.client.getEndpoint(), groupId, filter, top, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeSinglePageAsync(String groupId, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtManagementGroupScope(this.client.getEndpoint(), groupId, filter, top, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId, String filter, Integer top) {
        return new PagedFlux(() -> this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top), nextLink -> this.listAtManagementGroupScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top), nextLink -> this.listAtManagementGroupScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top, context), nextLink -> this.listAtManagementGroupScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(String groupId) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAtManagementGroupScopeAsync(groupId, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(String groupId, String filter, Integer top, Context context) {
        return new PagedIterable(this.listAtManagementGroupScopeAsync(groupId, filter, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtSubscriptionScopeWithResponseAsync(deploymentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtSubscriptionScopeWithResponseAsync(deploymentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName, Context context) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtSubscriptionScopeAsync(String deploymentName) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionScopeAsync(String deploymentName, Context context) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtSubscriptionScope(String deploymentName) {
        this.deleteAtSubscriptionScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtSubscriptionScope(String deploymentName, Context context) {
        this.deleteAtSubscriptionScopeAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistenceAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistenceAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName) {
        return this.checkExistenceAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistenceAtSubscriptionScope(String deploymentName) {
        Boolean value = (Boolean)this.checkExistenceAtSubscriptionScopeAsync(deploymentName).block();
        if (value != null) {
            return value;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.checkExistenceAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName) {
        return this.getAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentExtendedInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner getAtSubscriptionScope(String deploymentName) {
        return (DeploymentExtendedInner)((Object)this.getAtSubscriptionScopeAsync(deploymentName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.getAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAtSubscriptionScopeAsync(String deploymentName) {
        return this.cancelAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAtSubscriptionScope(String deploymentName) {
        this.cancelAtSubscriptionScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.cancelAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)this.validateAtSubscriptionScopeAsync(deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentValidateResultInner)this.validateAtSubscriptionScopeAsync(deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.whatIfAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScopeWithResponseAsync(String deploymentName, DeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.whatIfAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)this.whatIfAtSubscriptionScopeAsync(deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters, Context context) {
        return (WhatIfOperationResultInner)this.whatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportTemplateAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName) {
        return this.exportTemplateAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DeploymentExportResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtSubscriptionScope(String deploymentName) {
        return (DeploymentExportResultInner)this.exportTemplateAtSubscriptionScopeAsync(deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return (Response)this.exportTemplateAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listAtSubscriptionScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listAtSubscriptionScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top, context), nextLink -> this.listAtSubscriptionScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> list() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> list(String filter, Integer top, Context context) {
        return new PagedIterable(this.listAsync(filter, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, deploymentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, deploymentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String deploymentName) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String deploymentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentName) {
        this.deleteAsync(resourceGroupName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentName, Context context) {
        this.deleteAsync(resourceGroupName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistence(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistence(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName) {
        return this.checkExistenceWithResponseAsync(resourceGroupName, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        Boolean value = (Boolean)this.checkExistenceAsync(resourceGroupName, deploymentName).block();
        if (value != null) {
            return value;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceWithResponse(String resourceGroupName, String deploymentName, Context context) {
        return (Response)this.checkExistenceWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentExtendedInner.class), (Type)((Object)DeploymentExtendedInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAsync(resourceGroupName, deploymentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentExtendedInner)((Object)this.createOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentExtendedInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExtendedInner getByResourceGroup(String resourceGroupName, String deploymentName) {
        return (DeploymentExtendedInner)((Object)this.getByResourceGroupAsync(resourceGroupName, deploymentName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getByResourceGroupWithResponse(String resourceGroupName, String deploymentName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAsync(String resourceGroupName, String deploymentName) {
        return this.cancelWithResponseAsync(resourceGroupName, deploymentName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String deploymentName) {
        this.cancelAsync(resourceGroupName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String resourceGroupName, String deploymentName, Context context) {
        return (Response)this.cancelWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentValidateResultInner.class), (Type)((Object)DeploymentValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)this.validateAsync(resourceGroupName, deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return (DeploymentValidateResultInner)this.validateAsync(resourceGroupName, deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.whatIf(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfWithResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.whatIf(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.whatIfWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WhatIfOperationResultInner.class), (Type)((Object)WhatIfOperationResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)this.whatIfAsync(resourceGroupName, deploymentName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        return (WhatIfOperationResultInner)this.whatIfAsync(resourceGroupName, deploymentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateWithResponseAsync(String resourceGroupName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportTemplate(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName) {
        return this.exportTemplateWithResponseAsync(resourceGroupName, deploymentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DeploymentExportResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplate(String resourceGroupName, String deploymentName) {
        return (DeploymentExportResultInner)this.exportTemplateAsync(resourceGroupName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateWithResponse(String resourceGroupName, String deploymentName, Context context) {
        return (Response)this.exportTemplateWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TemplateHashResultInner>> calculateTemplateHashWithResponseAsync(Object template) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (template == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter template is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.calculateTemplateHash(this.client.getEndpoint(), this.client.getApiVersion(), template, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TemplateHashResultInner>> calculateTemplateHashWithResponseAsync(Object template, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (template == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter template is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.calculateTemplateHash(this.client.getEndpoint(), this.client.getApiVersion(), template, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TemplateHashResultInner> calculateTemplateHashAsync(Object template) {
        return this.calculateTemplateHashWithResponseAsync(template).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((TemplateHashResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TemplateHashResultInner calculateTemplateHash(Object template) {
        return (TemplateHashResultInner)this.calculateTemplateHashAsync(template).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TemplateHashResultInner> calculateTemplateHashWithResponse(Object template, Context context) {
        return (Response)this.calculateTemplateHashWithResponseAsync(template, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtManagementGroupScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtManagementGroupScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtSubscriptionScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtSubscriptionScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtSubscriptionScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtSubscriptionScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentListResult)res.getValue()).value(), ((DeploymentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ResourceManagementCl")
    private static interface DeploymentsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistenceAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExtendedInner>> getAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancelAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExportResultInner>> exportTemplateAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistenceAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ScopedDeployment var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExtendedInner>> getAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancelAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ScopedDeployment var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ScopedDeploymentWhatIf var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExportResultInner>> exportTemplateAtTenantScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtTenantScope(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistenceAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ScopedDeployment var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancelAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ScopedDeployment var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ScopedDeploymentWhatIf var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExportResultInner>> exportTemplateAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="groupId") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistenceAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") DeploymentInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancelAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") DeploymentInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") DeploymentWhatIf var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExportResultInner>> exportTemplateAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="deploymentName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistence(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") DeploymentInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExtendedInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") DeploymentInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> whatIf(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") DeploymentWhatIf var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentExportResultInner>> exportTemplate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="deploymentName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/calculateTemplateHash")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TemplateHashResultInner>> calculateTemplateHash(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") Object var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtTenantScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtManagementGroupScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listAtSubscriptionScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

