// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExportResultInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentValidateResultInner;
import com.azure.resourcemanager.resources.fluent.models.TemplateHashResultInner;
import com.azure.resourcemanager.resources.fluent.models.WhatIfOperationResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.DeploymentWhatIf;
import com.azure.resourcemanager.resources.models.ScopedDeployment;
import com.azure.resourcemanager.resources.models.ScopedDeploymentWhatIf;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DeploymentsClient. */
public interface DeploymentsClient
    extends InnerSupportsGet<DeploymentExtendedInner>,
        InnerSupportsListing<DeploymentExtendedInner>,
        InnerSupportsDelete<Void> {
    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtScopeWithResponseAsync(String scope, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtScopeAsync(String scope, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtScopeAsync(String scope, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtScope(String scope, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtScope(String scope, String deploymentName, Context context);

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> checkExistenceAtScopeWithResponseAsync(String scope, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean checkExistenceAtScope(String scope, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> checkExistenceAtScopeWithResponse(String scope, String deploymentName, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScopeWithResponseAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScope(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScope(
        String scope, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> createOrUpdateAtScopeAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtScope(
        String scope, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExtendedInner>> getAtScopeWithResponseAsync(String scope, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner getAtScope(String scope, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExtendedInner> getAtScopeWithResponse(String scope, String deploymentName, Context context);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelAtScopeWithResponseAsync(String scope, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAtScopeAsync(String scope, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancelAtScope(String scope, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelAtScopeWithResponse(String scope, String deploymentName, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateAtScopeWithResponseAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScopeAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScope(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtScope(
        String scope, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentValidateResultInner> validateAtScopeAsync(
        String scope, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtScope(String scope, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtScope(
        String scope, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExportResultInner>> exportTemplateAtScopeWithResponseAsync(
        String scope, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExportResultInner exportTemplateAtScope(String scope, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExportResultInner> exportTemplateAtScopeWithResponse(
        String scope, String deploymentName, Context context);

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope, String filter, Integer top);

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope);

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtScope(String scope);

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtScope(String scope, String filter, Integer top, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScopeWithResponseAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtTenantScopeAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtTenantScopeAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtTenantScope(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtTenantScope(String deploymentName, Context context);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> checkExistenceAtTenantScopeWithResponseAsync(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean checkExistenceAtTenantScope(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> checkExistenceAtTenantScopeWithResponse(String deploymentName, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScopeWithResponseAsync(
        String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(
        String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScope(
        String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtTenantScope(
        String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtTenantScope(
        String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExtendedInner>> getAtTenantScopeWithResponseAsync(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner getAtTenantScope(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExtendedInner> getAtTenantScopeWithResponse(String deploymentName, Context context);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelAtTenantScopeWithResponseAsync(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAtTenantScopeAsync(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancelAtTenantScope(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelAtTenantScopeWithResponse(String deploymentName, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateAtTenantScopeWithResponseAsync(
        String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScope(
        String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAtTenantScope(
        String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtTenantScope(
        String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScopeWithResponseAsync(
        String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(
        String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScope(
        String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtTenantScope(
        String deploymentName, ScopedDeploymentWhatIf parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtTenantScope(
        String deploymentName, ScopedDeploymentWhatIf parameters, Context context);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExportResultInner>> exportTemplateAtTenantScopeWithResponseAsync(String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExportResultInner exportTemplateAtTenantScope(String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExportResultInner> exportTemplateAtTenantScopeWithResponse(
        String deploymentName, Context context);

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync(String filter, Integer top);

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync();

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtTenantScope();

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtTenantScope(String filter, Integer top, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(
        String groupId, String deploymentName, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroupScope(String groupId, String deploymentName, Context context);

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> checkExistenceAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean checkExistenceAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> checkExistenceAtManagementGroupScopeWithResponse(
        String groupId, String deploymentName, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtManagementGroupScopeAsync(
            String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner getAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExtendedInner> getAtManagementGroupScopeWithResponse(
        String groupId, String deploymentName, Context context);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancelAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelAtManagementGroupScopeWithResponse(String groupId, String deploymentName, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScope(
            String groupId, String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeployment parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtManagementGroupScopeAsync(
            String groupId, String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtManagementGroupScope(
        String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, Context context);

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExportResultInner>> exportTemplateAtManagementGroupScopeWithResponseAsync(
        String groupId, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExportResultInner exportTemplateAtManagementGroupScope(String groupId, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeWithResponse(
        String groupId, String deploymentName, Context context);

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId, String filter, Integer top);

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId);

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(String groupId);

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(
        String groupId, String filter, Integer top, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScopeWithResponseAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtSubscriptionScopeAsync(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtSubscriptionScope(String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtSubscriptionScope(String deploymentName, Context context);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> checkExistenceAtSubscriptionScopeWithResponseAsync(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean checkExistenceAtSubscriptionScope(String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> checkExistenceAtSubscriptionScopeWithResponse(String deploymentName, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScopeWithResponseAsync(
        String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScope(
        String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScope(
        String deploymentName, DeploymentInner parameters, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(
        String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdateAtSubscriptionScope(
        String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScopeWithResponseAsync(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner getAtSubscriptionScope(String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExtendedInner> getAtSubscriptionScopeWithResponse(String deploymentName, Context context);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelAtSubscriptionScopeWithResponseAsync(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAtSubscriptionScopeAsync(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancelAtSubscriptionScope(String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelAtSubscriptionScopeWithResponse(String deploymentName, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScopeWithResponseAsync(
        String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(
        String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validateAtSubscriptionScope(
        String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScopeWithResponseAsync(
        String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(
        String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScope(
        String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAtSubscriptionScope(
        String deploymentName, DeploymentWhatIf parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIfAtSubscriptionScope(
        String deploymentName, DeploymentWhatIf parameters, Context context);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExportResultInner>> exportTemplateAtSubscriptionScopeWithResponseAsync(
        String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExportResultInner exportTemplateAtSubscriptionScope(String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeWithResponse(
        String deploymentName, Context context);

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAsync(String filter, Integer top);

    /**
     * Get all the deployments for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listAsync();

    /**
     * Get all the deployments for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> list();

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> list(String filter, Integer top, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName, Context context);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String deploymentName);

    /**
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String deploymentName, Context context);

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean checkExistence(String resourceGroupName, String deploymentName);

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> checkExistenceWithResponse(String resourceGroupName, String deploymentName, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> createOrUpdateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     *     The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner createOrUpdate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExtendedInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExtendedInner getByResourceGroup(String resourceGroupName, String deploymentName);

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExtendedInner> getByResourceGroupWithResponse(
        String resourceGroupName, String deploymentName, Context context);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAsync(String resourceGroupName, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancel(String resourceGroupName, String deploymentName);

    /**
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelWithResponse(String resourceGroupName, String deploymentName, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentValidateResultInner> validateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName, DeploymentInner parameters);

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentValidateResultInner validate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> whatIfWithResponseAsync(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAsync(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIf(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIf(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<WhatIfOperationResultInner> whatIfAsync(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters);

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     *     insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WhatIfOperationResultInner whatIf(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context);

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentExportResultInner>> exportTemplateWithResponseAsync(
        String resourceGroupName, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentExportResultInner exportTemplate(String resourceGroupName, String deploymentName);

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentExportResultInner> exportTemplateWithResponse(
        String resourceGroupName, String deploymentName, Context context);

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     *     insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top);

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     *     insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     *     insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName);

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     *     insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     *     '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentExtendedInner> listByResourceGroup(
        String resourceGroupName, String filter, Integer top, Context context);

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TemplateHashResultInner>> calculateTemplateHashWithResponseAsync(Object template);

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TemplateHashResultInner> calculateTemplateHashAsync(Object template);

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TemplateHashResultInner calculateTemplateHash(Object template);

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TemplateHashResultInner> calculateTemplateHashWithResponse(Object template, Context context);
}
