// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.FeatureResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in FeaturesClient. */
public interface FeaturesClient {
    /**
     * Gets all the preview features that are available through AFEC for the subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features that are available through AFEC for the subscription as paginated response with
     *     {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FeatureResultInner> listAllAsync();

    /**
     * Gets all the preview features that are available through AFEC for the subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features that are available through AFEC for the subscription as paginated response with
     *     {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FeatureResultInner> listAll();

    /**
     * Gets all the preview features that are available through AFEC for the subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features that are available through AFEC for the subscription as paginated response with
     *     {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FeatureResultInner> listAll(Context context);

    /**
     * Gets all the preview features in a provider namespace that are available through AFEC for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider for getting features.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features in a provider namespace that are available through AFEC for the subscription as
     *     paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FeatureResultInner> listAsync(String resourceProviderNamespace);

    /**
     * Gets all the preview features in a provider namespace that are available through AFEC for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider for getting features.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features in a provider namespace that are available through AFEC for the subscription as
     *     paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FeatureResultInner> list(String resourceProviderNamespace);

    /**
     * Gets all the preview features in a provider namespace that are available through AFEC for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider for getting features.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the preview features in a provider namespace that are available through AFEC for the subscription as
     *     paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FeatureResultInner> list(String resourceProviderNamespace, Context context);

    /**
     * Gets the preview feature with the specified name.
     *
     * @param resourceProviderNamespace The resource provider namespace for the feature.
     * @param featureName The name of the feature to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the preview feature with the specified name along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FeatureResultInner>> getWithResponseAsync(String resourceProviderNamespace, String featureName);

    /**
     * Gets the preview feature with the specified name.
     *
     * @param resourceProviderNamespace The resource provider namespace for the feature.
     * @param featureName The name of the feature to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the preview feature with the specified name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FeatureResultInner> getAsync(String resourceProviderNamespace, String featureName);

    /**
     * Gets the preview feature with the specified name.
     *
     * @param resourceProviderNamespace The resource provider namespace for the feature.
     * @param featureName The name of the feature to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the preview feature with the specified name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FeatureResultInner get(String resourceProviderNamespace, String featureName);

    /**
     * Gets the preview feature with the specified name.
     *
     * @param resourceProviderNamespace The resource provider namespace for the feature.
     * @param featureName The name of the feature to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the preview feature with the specified name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FeatureResultInner> getWithResponse(String resourceProviderNamespace, String featureName, Context context);

    /**
     * Registers the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to register.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FeatureResultInner>> registerWithResponseAsync(String resourceProviderNamespace, String featureName);

    /**
     * Registers the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to register.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FeatureResultInner> registerAsync(String resourceProviderNamespace, String featureName);

    /**
     * Registers the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to register.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FeatureResultInner register(String resourceProviderNamespace, String featureName);

    /**
     * Registers the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to register.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FeatureResultInner> registerWithResponse(
        String resourceProviderNamespace, String featureName, Context context);

    /**
     * Unregisters the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to unregister.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FeatureResultInner>> unregisterWithResponseAsync(
        String resourceProviderNamespace, String featureName);

    /**
     * Unregisters the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to unregister.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FeatureResultInner> unregisterAsync(String resourceProviderNamespace, String featureName);

    /**
     * Unregisters the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to unregister.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FeatureResultInner unregister(String resourceProviderNamespace, String featureName);

    /**
     * Unregisters the preview feature for the subscription.
     *
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param featureName The name of the feature to unregister.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return previewed feature information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FeatureResultInner> unregisterWithResponse(
        String resourceProviderNamespace, String featureName, Context context);
}
