// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.resources.models.DataEffect;
import com.azure.resourcemanager.resources.models.DataManifestCustomResourceFunctionDefinition;
import com.azure.resourcemanager.resources.models.ResourceTypeAliases;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The data policy manifest. */
@Fluent
public final class DataPolicyManifestInner extends ProxyResource {
    /*
     * The data policy manifest properties.
     */
    @JsonProperty(value = "properties")
    private DataPolicyManifestProperties innerProperties;

    /**
     * Get the innerProperties property: The data policy manifest properties.
     *
     * @return the innerProperties value.
     */
    private DataPolicyManifestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the namespaces property: The list of namespaces for the data policy manifest.
     *
     * @return the namespaces value.
     */
    public List<String> namespaces() {
        return this.innerProperties() == null ? null : this.innerProperties().namespaces();
    }

    /**
     * Set the namespaces property: The list of namespaces for the data policy manifest.
     *
     * @param namespaces the namespaces value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withNamespaces(List<String> namespaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withNamespaces(namespaces);
        return this;
    }

    /**
     * Get the policyMode property: The policy mode of the data policy manifest.
     *
     * @return the policyMode value.
     */
    public String policyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().policyMode();
    }

    /**
     * Set the policyMode property: The policy mode of the data policy manifest.
     *
     * @param policyMode the policyMode value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withPolicyMode(String policyMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withPolicyMode(policyMode);
        return this;
    }

    /**
     * Get the isBuiltInOnly property: A value indicating whether policy mode is allowed only in built-in definitions.
     *
     * @return the isBuiltInOnly value.
     */
    public Boolean isBuiltInOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().isBuiltInOnly();
    }

    /**
     * Set the isBuiltInOnly property: A value indicating whether policy mode is allowed only in built-in definitions.
     *
     * @param isBuiltInOnly the isBuiltInOnly value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withIsBuiltInOnly(Boolean isBuiltInOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withIsBuiltInOnly(isBuiltInOnly);
        return this;
    }

    /**
     * Get the resourceTypeAliases property: An array of resource type aliases.
     *
     * @return the resourceTypeAliases value.
     */
    public List<ResourceTypeAliases> resourceTypeAliases() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceTypeAliases();
    }

    /**
     * Set the resourceTypeAliases property: An array of resource type aliases.
     *
     * @param resourceTypeAliases the resourceTypeAliases value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withResourceTypeAliases(List<ResourceTypeAliases> resourceTypeAliases) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withResourceTypeAliases(resourceTypeAliases);
        return this;
    }

    /**
     * Get the effects property: The effect definition.
     *
     * @return the effects value.
     */
    public List<DataEffect> effects() {
        return this.innerProperties() == null ? null : this.innerProperties().effects();
    }

    /**
     * Set the effects property: The effect definition.
     *
     * @param effects the effects value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withEffects(List<DataEffect> effects) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withEffects(effects);
        return this;
    }

    /**
     * Get the fieldValues property: The non-alias field accessor values that can be used in the policy rule.
     *
     * @return the fieldValues value.
     */
    public List<String> fieldValues() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldValues();
    }

    /**
     * Set the fieldValues property: The non-alias field accessor values that can be used in the policy rule.
     *
     * @param fieldValues the fieldValues value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withFieldValues(List<String> fieldValues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withFieldValues(fieldValues);
        return this;
    }

    /**
     * Get the standard property: The standard resource functions (subscription and/or resourceGroup).
     *
     * @return the standard value.
     */
    public List<String> standard() {
        return this.innerProperties() == null ? null : this.innerProperties().standard();
    }

    /**
     * Set the standard property: The standard resource functions (subscription and/or resourceGroup).
     *
     * @param standard the standard value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withStandard(List<String> standard) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withStandard(standard);
        return this;
    }

    /**
     * Get the custom property: An array of data manifest custom resource definition.
     *
     * @return the custom value.
     */
    public List<DataManifestCustomResourceFunctionDefinition> custom() {
        return this.innerProperties() == null ? null : this.innerProperties().custom();
    }

    /**
     * Set the custom property: An array of data manifest custom resource definition.
     *
     * @param custom the custom value to set.
     * @return the DataPolicyManifestInner object itself.
     */
    public DataPolicyManifestInner withCustom(List<DataManifestCustomResourceFunctionDefinition> custom) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataPolicyManifestProperties();
        }
        this.innerProperties().withCustom(custom);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
