// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Check zone peers request parameters. */
@Fluent
public final class CheckZonePeersRequest {
    /*
     * The Microsoft location.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The peer Microsoft Azure subscription ID.
     */
    @JsonProperty(value = "subscriptionIds")
    private List<String> subscriptionIds;

    /**
     * Get the location property: The Microsoft location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The Microsoft location.
     *
     * @param location the location value to set.
     * @return the CheckZonePeersRequest object itself.
     */
    public CheckZonePeersRequest withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the subscriptionIds property: The peer Microsoft Azure subscription ID.
     *
     * @return the subscriptionIds value.
     */
    public List<String> subscriptionIds() {
        return this.subscriptionIds;
    }

    /**
     * Set the subscriptionIds property: The peer Microsoft Azure subscription ID.
     *
     * @param subscriptionIds the subscriptionIds value to set.
     * @return the CheckZonePeersRequest object itself.
     */
    public CheckZonePeersRequest withSubscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
