// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for ResourceChangeType. */
public enum ResourceChangeType {
    /** Enum value Update. */
    UPDATE("Update"),

    /** Enum value Delete. */
    DELETE("Delete"),

    /** Enum value Create. */
    CREATE("Create");

    /** The actual serialized value for a ResourceChangeType instance. */
    private final String value;

    ResourceChangeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResourceChangeType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ResourceChangeType object, or null if unable to parse.
     */
    @JsonCreator
    public static ResourceChangeType fromString(String value) {
        ResourceChangeType[] items = ResourceChangeType.values();
        for (ResourceChangeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
