// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The PolicyAssignmentUpdate model. */
@Fluent
public final class PolicyAssignmentUpdate {
    /*
     * The location of the policy assignment. Only required when utilizing
     * managed identity.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The managed identity associated with the policy assignment.
     */
    @JsonProperty(value = "identity")
    private Identity identity;

    /**
     * Get the location property: The location of the policy assignment. Only required when utilizing managed identity.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the policy assignment. Only required when utilizing managed identity.
     *
     * @param location the location value to set.
     * @return the PolicyAssignmentUpdate object itself.
     */
    public PolicyAssignmentUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the identity property: The managed identity associated with the policy assignment.
     *
     * @return the identity value.
     */
    public Identity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The managed identity associated with the policy assignment.
     *
     * @param identity the identity value to set.
     * @return the PolicyAssignmentUpdate object itself.
     */
    public PolicyAssignmentUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }
}
