// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An individual change on the target resource. */
@Immutable
public final class ChangeBase {
    /*
     * The type of change that occurred
     */
    @JsonProperty(value = "propertyChangeType", access = JsonProperty.Access.WRITE_ONLY)
    private ResourcePropertyChangeType propertyChangeType;

    /*
     * The entity that made the change
     */
    @JsonProperty(value = "changeCategory", access = JsonProperty.Access.WRITE_ONLY)
    private ChangeCategory changeCategory;

    /*
     * The target resource property value before the change
     */
    @JsonProperty(value = "previousValue", access = JsonProperty.Access.WRITE_ONLY)
    private String previousValue;

    /*
     * The target resource property value after the change
     */
    @JsonProperty(value = "newValue", access = JsonProperty.Access.WRITE_ONLY)
    private String newValue;

    /**
     * Get the propertyChangeType property: The type of change that occurred.
     *
     * @return the propertyChangeType value.
     */
    public ResourcePropertyChangeType propertyChangeType() {
        return this.propertyChangeType;
    }

    /**
     * Get the changeCategory property: The entity that made the change.
     *
     * @return the changeCategory value.
     */
    public ChangeCategory changeCategory() {
        return this.changeCategory;
    }

    /**
     * Get the previousValue property: The target resource property value before the change.
     *
     * @return the previousValue value.
     */
    public String previousValue() {
        return this.previousValue;
    }

    /**
     * Get the newValue property: The target resource property value after the change.
     *
     * @return the newValue value.
     */
    public String newValue() {
        return this.newValue;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
