/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.model.implementation;

import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskItem;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

public class ExecuteTask<ResultT extends Indexable>
implements TaskItem {
    private Executor<ResultT> executor;
    private ResultT result;

    public ExecuteTask(Executor<ResultT> executor) {
        this.executor = executor;
    }

    public ResultT result() {
        return this.result;
    }

    @Override
    public void beforeGroupInvoke() {
        this.executor.beforeGroupExecute();
    }

    @Override
    public boolean isHot() {
        return this.executor.isHot();
    }

    @Override
    public Mono<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        return this.executor.executeWorkAsync().subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).doOnNext(resultT -> {
            this.result = resultT;
        }).map(resourceT -> resourceT);
    }

    @Override
    public Mono<Void> invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return this.executor.afterPostRunAsync(isGroupFaulted);
    }

    public static interface Executor<T extends Indexable> {
        public void beforeGroupExecute();

        public boolean isHot();

        public Mono<T> executeWorkAsync();

        public Mono<Void> afterPostRunAsync(boolean var1);
    }
}

