/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.Providers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class ProviderRegistrationPolicy
implements HttpPipelinePolicy {
    private static final String MISSING_SUBSCRIPTION_REGISTRATION = "MissingSubscriptionRegistration";
    private Providers providers;

    public ProviderRegistrationPolicy() {
    }

    public ProviderRegistrationPolicy(ResourceManager resourceManager) {
        this.providers = resourceManager.providers();
    }

    public ProviderRegistrationPolicy(Providers providers) {
        this.providers = providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public Providers getProviders() {
        return this.providers;
    }

    private boolean isResponseSuccessful(HttpResponse response) {
        return response.getStatusCode() >= 200 && response.getStatusCode() < 300;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (this.providers == null) {
            return next.process();
        }
        return next.clone().process().flatMap(response -> {
            if (!this.isResponseSuccessful((HttpResponse)response)) {
                HttpResponse bufferedResponse = response.buffer();
                return FluxUtil.collectBytesInByteBufferStream((Flux)bufferedResponse.getBody()).flatMap(body -> {
                    ManagementError managementError;
                    String bodyStr = new String((byte[])body, StandardCharsets.UTF_8);
                    SerializerAdapter jacksonAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
                    try {
                        managementError = (ManagementError)jacksonAdapter.deserialize(bodyStr, ManagementError.class, SerializerEncoding.JSON);
                    }
                    catch (IOException e) {
                        return Mono.just((Object)bufferedResponse);
                    }
                    if (managementError != null && MISSING_SUBSCRIPTION_REGISTRATION.equals(managementError.getCode())) {
                        String resourceNamespace = null;
                        if (managementError.getDetails() != null) {
                            resourceNamespace = managementError.getDetails().stream().filter(d -> MISSING_SUBSCRIPTION_REGISTRATION.equals(d.getCode()) && d.getTarget() != null).map(ManagementError::getTarget).findFirst().orElse(null);
                        }
                        if (resourceNamespace == null) {
                            Pattern providerPattern = Pattern.compile(".*'(.*)'");
                            Matcher providerMatcher = providerPattern.matcher(managementError.getMessage());
                            if (!providerMatcher.find()) {
                                return Mono.just((Object)bufferedResponse);
                            }
                            resourceNamespace = providerMatcher.group(1);
                        }
                        return this.registerProviderUntilSuccess(resourceNamespace).then(Mono.just((Object)bufferedResponse)).onErrorReturn((Object)bufferedResponse).then(next.clone().process());
                    }
                    return Mono.just((Object)bufferedResponse);
                });
            }
            return Mono.just((Object)response);
        });
    }

    private Mono<Void> registerProviderUntilSuccess(String namespace) {
        return this.providers.registerAsync(namespace).flatMap(provider -> {
            if (this.isProviderRegistered((Provider)provider)) {
                return Mono.empty();
            }
            return this.providers.getByNameAsync(namespace).flatMap(this::checkProviderRegistered).retryWhen((Retry)Retry.fixedDelay((long)30L, (Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(Duration.ofSeconds(10L))).filter(ProviderUnregisteredException.class::isInstance));
        });
    }

    private Mono<Void> checkProviderRegistered(Provider provider) throws ProviderUnregisteredException {
        if (this.isProviderRegistered(provider)) {
            return Mono.empty();
        }
        return Mono.error((Throwable)new ProviderUnregisteredException());
    }

    private boolean isProviderRegistered(Provider provider) {
        return "Registered".equalsIgnoreCase(provider.registrationState());
    }

    private static class ProviderUnregisteredException
    extends RuntimeException {
        private ProviderUnregisteredException() {
        }
    }
}

