// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.ChangeResourceResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ChangesClient. */
public interface ChangesClient {
    /**
     * Obtains a list of change resources from the past 14 days for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param top (Optional) Set the maximum number of results per response.
     * @param skipToken (Optional) The page-continuation token.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ChangeResourceResultInner> listAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        Long top,
        String skipToken);

    /**
     * Obtains a list of change resources from the past 14 days for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ChangeResourceResultInner> listAsync(
        String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName);

    /**
     * Obtains a list of change resources from the past 14 days for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ChangeResourceResultInner> list(
        String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName);

    /**
     * Obtains a list of change resources from the past 14 days for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param top (Optional) Set the maximum number of results per response.
     * @param skipToken (Optional) The page-continuation token.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ChangeResourceResultInner> list(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        Long top,
        String skipToken,
        Context context);

    /**
     * Obtains the specified change resource for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param changeResourceId The ID of the change resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change Resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ChangeResourceResultInner>> getWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String changeResourceId);

    /**
     * Obtains the specified change resource for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param changeResourceId The ID of the change resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change Resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ChangeResourceResultInner> getAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String changeResourceId);

    /**
     * Obtains the specified change resource for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param changeResourceId The ID of the change resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change Resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ChangeResourceResultInner> getWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String changeResourceId,
        Context context);

    /**
     * Obtains the specified change resource for the target resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The name of the resource provider namespace.
     * @param resourceType The name of the resource type.
     * @param resourceName The name of the resource.
     * @param changeResourceId The ID of the change resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return change Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ChangeResourceResultInner get(
        String resourceGroupName,
        String resourceProviderNamespace,
        String resourceType,
        String resourceName,
        String changeResourceId);
}
