// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluent.PolicySetDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import com.azure.resourcemanager.resources.models.PolicySetDefinitionListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PolicySetDefinitionsClient. */
public final class PolicySetDefinitionsClientImpl implements PolicySetDefinitionsClient {
    /** The proxy service used to perform REST calls. */
    private final PolicySetDefinitionsService service;

    /** The service client containing this operation class. */
    private final PolicyClientImpl client;

    /**
     * Initializes an instance of PolicySetDefinitionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PolicySetDefinitionsClientImpl(PolicyClientImpl client) {
        this.service =
            RestProxy
                .create(PolicySetDefinitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicyClientPolicySetDefinitions to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PolicyClientPolicySe")
    public interface PolicySetDefinitionsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") PolicySetDefinitionInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> getBuiltIn(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam(value = "$filter", encoded = true) String filter,
            @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listBuiltIn(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @QueryParam(value = "$filter", encoded = true) String filter,
            @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            @BodyParam("application/json") PolicySetDefinitionInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> deleteAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> getAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listByManagementGroup(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            @QueryParam(value = "$filter", encoded = true) String filter,
            @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listBuiltInNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listByManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                policySetDefinitionName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateWithResponse(
        String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, parameters, context).block();
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdate(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateWithResponse(policySetDefinitionName, parameters, Context.NONE).getValue();
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                policySetDefinitionName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policySetDefinitionName) {
        return deleteWithResponseAsync(policySetDefinitionName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policySetDefinitionName, Context context) {
        return deleteWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String policySetDefinitionName) {
        deleteWithResponse(policySetDefinitionName, Context.NONE);
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(
        String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                policySetDefinitionName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        return getWithResponseAsync(policySetDefinitionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getWithResponse(String policySetDefinitionName, Context context) {
        return getWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        return getWithResponse(policySetDefinitionName, Context.NONE).getValue();
    }

    /**
     * Retrieves a built in policy set definition.
     *
     * <p>This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a built in policy set definition.
     *
     * <p>This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(
        String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, apiVersion, accept, context);
    }

    /**
     * Retrieves a built in policy set definition.
     *
     * <p>This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        return getBuiltInWithResponseAsync(policySetDefinitionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a built in policy set definition.
     *
     * <p>This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getBuiltInWithResponse(String policySetDefinitionName, Context context) {
        return getBuiltInWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * Retrieves a built in policy set definition.
     *
     * <p>This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        return getBuiltInWithResponse(policySetDefinitionName, Context.NONE).getValue();
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            filter,
                            top,
                            accept,
                            context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(
        String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), filter, top, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listAsync(String filter, Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter, top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listAsync() {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter, top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, top, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list() {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listAsync(filter, top));
    }

    /**
     * Retrieves the policy set definitions for a subscription.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list(String filter, Integer top, Context context) {
        return new PagedIterable<>(listAsync(filter, top, context));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBuiltIn(this.client.getEndpoint(), apiVersion, filter, top, accept, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(
        String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBuiltIn(this.client.getEndpoint(), apiVersion, filter, top, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(String filter, Integer top) {
        return new PagedFlux<>(
            () -> listBuiltInSinglePageAsync(filter, top), nextLink -> listBuiltInNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync() {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listBuiltInSinglePageAsync(filter, top), nextLink -> listBuiltInNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(String filter, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listBuiltInSinglePageAsync(filter, top, context),
            nextLink -> listBuiltInNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn() {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listBuiltInAsync(filter, top));
    }

    /**
     * Retrieves built-in policy set definitions.
     *
     * <p>This operation retrieves a list of all the built-in policy set definitions that match the optional given
     * $filter. If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn(String filter, Integer top, Context context) {
        return new PagedIterable<>(listBuiltInAsync(filter, top, context));
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdateAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            managementGroupId,
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String policySetDefinitionName,
        String managementGroupId,
        PolicySetDefinitionInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdateAtManagementGroup(
                this.client.getEndpoint(),
                policySetDefinitionName,
                apiVersion,
                managementGroupId,
                parameters,
                accept,
                context);
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateAtManagementGroupWithResponse(
        String policySetDefinitionName,
        String managementGroupId,
        PolicySetDefinitionInner parameters,
        Context context) {
        return createOrUpdateAtManagementGroupWithResponseAsync(
                policySetDefinitionName, managementGroupId, parameters, context)
            .block();
    }

    /**
     * Creates or updates a policy set definition.
     *
     * <p>This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupWithResponse(
                policySetDefinitionName, managementGroupId, parameters, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            managementGroupId,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteAtManagementGroup(
                this.client.getEndpoint(), policySetDefinitionName, apiVersion, managementGroupId, accept, context);
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(
        String policySetDefinitionName, String managementGroupId, Context context) {
        return deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    /**
     * Deletes a policy set definition.
     *
     * <p>This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        deleteAtManagementGroupWithResponse(policySetDefinitionName, managementGroupId, Context.NONE);
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            apiVersion,
                            managementGroupId,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getAtManagementGroup(
                this.client.getEndpoint(), policySetDefinitionName, apiVersion, managementGroupId, accept, context);
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAtManagementGroupAsync(
        String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getAtManagementGroupWithResponse(
        String policySetDefinitionName, String managementGroupId, Context context) {
        return getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    /**
     * Retrieves a policy set definition.
     *
     * <p>This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupWithResponse(policySetDefinitionName, managementGroupId, Context.NONE).getValue();
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupId, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByManagementGroup(
                            this.client.getEndpoint(), apiVersion, managementGroupId, filter, top, accept, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupId, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByManagementGroup(
                this.client.getEndpoint(), apiVersion, managementGroupId, filter, top, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(
        String managementGroupId, String filter, Integer top) {
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupId, filter, top),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupId, filter, top),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(
        String managementGroupId, String filter, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupId, filter, top, context),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listByManagementGroupAsync(managementGroupId, filter, top));
    }

    /**
     * Retrieves all policy set definitions in management group.
     *
     * <p>This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     *     -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     *     $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the
     *     given scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     *     Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set
     *     definitions whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(
        String managementGroupId, String filter, Integer top, Context context) {
        return new PagedIterable<>(listByManagementGroupAsync(managementGroupId, filter, top, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBuiltInNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBuiltInNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
