// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The policy assignment properties for Patch request. */
@Fluent
public final class PolicyAssignmentUpdateProperties {
    /*
     * The resource selector list to filter policies by resource properties.
     */
    @JsonProperty(value = "resourceSelectors")
    private List<ResourceSelector> resourceSelectors;

    /*
     * The policy property value override.
     */
    @JsonProperty(value = "overrides")
    private List<OverrideModel> overrides;

    /** Creates an instance of PolicyAssignmentUpdateProperties class. */
    public PolicyAssignmentUpdateProperties() {
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     *
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     *
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyAssignmentUpdateProperties object itself.
     */
    public PolicyAssignmentUpdateProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    /**
     * Get the overrides property: The policy property value override.
     *
     * @return the overrides value.
     */
    public List<OverrideModel> overrides() {
        return this.overrides;
    }

    /**
     * Set the overrides property: The policy property value override.
     *
     * @param overrides the overrides value to set.
     * @return the PolicyAssignmentUpdateProperties object itself.
     */
    public PolicyAssignmentUpdateProperties withOverrides(List<OverrideModel> overrides) {
        this.overrides = overrides;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceSelectors() != null) {
            resourceSelectors().forEach(e -> e.validate());
        }
        if (overrides() != null) {
            overrides().forEach(e -> e.validate());
        }
    }
}
