// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** General metadata for the parameter. */
@Fluent
public final class ParameterDefinitionsValueMetadata {
    /*
     * The display name for the parameter.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The description of the parameter.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Used when assigning the policy definition through the portal. Provides a context aware list of values for the
     * user to choose from.
     */
    @JsonProperty(value = "strongType")
    private String strongType;

    /*
     * Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this
     * parameter during policy assignment. This property is useful in case you wish to assign permissions outside the
     * assignment scope.
     */
    @JsonProperty(value = "assignPermissions")
    private Boolean assignPermissions;

    /*
     * General metadata for the parameter.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of ParameterDefinitionsValueMetadata class. */
    public ParameterDefinitionsValueMetadata() {
    }

    /**
     * Get the displayName property: The display name for the parameter.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the parameter.
     *
     * @param displayName the displayName value to set.
     * @return the ParameterDefinitionsValueMetadata object itself.
     */
    public ParameterDefinitionsValueMetadata withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description of the parameter.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the parameter.
     *
     * @param description the description value to set.
     * @return the ParameterDefinitionsValueMetadata object itself.
     */
    public ParameterDefinitionsValueMetadata withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the strongType property: Used when assigning the policy definition through the portal. Provides a context
     * aware list of values for the user to choose from.
     *
     * @return the strongType value.
     */
    public String strongType() {
        return this.strongType;
    }

    /**
     * Set the strongType property: Used when assigning the policy definition through the portal. Provides a context
     * aware list of values for the user to choose from.
     *
     * @param strongType the strongType value to set.
     * @return the ParameterDefinitionsValueMetadata object itself.
     */
    public ParameterDefinitionsValueMetadata withStrongType(String strongType) {
        this.strongType = strongType;
        return this;
    }

    /**
     * Get the assignPermissions property: Set to true to have Azure portal create role assignments on the resource ID
     * or resource scope value of this parameter during policy assignment. This property is useful in case you wish to
     * assign permissions outside the assignment scope.
     *
     * @return the assignPermissions value.
     */
    public Boolean assignPermissions() {
        return this.assignPermissions;
    }

    /**
     * Set the assignPermissions property: Set to true to have Azure portal create role assignments on the resource ID
     * or resource scope value of this parameter during policy assignment. This property is useful in case you wish to
     * assign permissions outside the assignment scope.
     *
     * @param assignPermissions the assignPermissions value to set.
     * @return the ParameterDefinitionsValueMetadata object itself.
     */
    public ParameterDefinitionsValueMetadata withAssignPermissions(Boolean assignPermissions) {
        this.assignPermissions = assignPermissions;
        return this;
    }

    /**
     * Get the additionalProperties property: General metadata for the parameter.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: General metadata for the parameter.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the ParameterDefinitionsValueMetadata object itself.
     */
    public ParameterDefinitionsValueMetadata withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
