// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The resource selector to filter policies by resource properties. */
@Fluent
public final class ResourceSelector {
    /*
     * The name of the resource selector.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The list of the selector expressions.
     */
    @JsonProperty(value = "selectors")
    private List<Selector> selectors;

    /** Creates an instance of ResourceSelector class. */
    public ResourceSelector() {
    }

    /**
     * Get the name property: The name of the resource selector.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource selector.
     *
     * @param name the name value to set.
     * @return the ResourceSelector object itself.
     */
    public ResourceSelector withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the selectors property: The list of the selector expressions.
     *
     * @return the selectors value.
     */
    public List<Selector> selectors() {
        return this.selectors;
    }

    /**
     * Set the selectors property: The list of the selector expressions.
     *
     * @param selectors the selectors value to set.
     * @return the ResourceSelector object itself.
     */
    public ResourceSelector withSelectors(List<Selector> selectors) {
        this.selectors = selectors;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (selectors() != null) {
            selectors().forEach(e -> e.validate());
        }
    }
}
