// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.resources.models.WhatIfChange;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result of the What-If operation. Contains a list of predicted changes and a URL link to get to the next set of
 * results.
 */
@Fluent
public final class WhatIfOperationResultInner {
    /*
     * Status of the What-If operation.
     */
    @JsonProperty(value = "status")
    private String status;

    /*
     * What-If operation properties.
     */
    @JsonProperty(value = "properties")
    private WhatIfOperationProperties innerProperties;

    /*
     * Error Response
     *
     * Error when What-If operation fails.
     */
    @JsonProperty(value = "error")
    private ManagementError error;

    /** Creates an instance of WhatIfOperationResultInner class. */
    public WhatIfOperationResultInner() {
    }

    /**
     * Get the status property: Status of the What-If operation.
     *
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the What-If operation.
     *
     * @param status the status value to set.
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the innerProperties property: What-If operation properties.
     *
     * @return the innerProperties value.
     */
    private WhatIfOperationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the error property: Error Response
     *
     * <p>Error when What-If operation fails.
     *
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: Error Response
     *
     * <p>Error when What-If operation fails.
     *
     * @param error the error value to set.
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the changes property: List of resource changes predicted by What-If operation.
     *
     * @return the changes value.
     */
    public List<WhatIfChange> changes() {
        return this.innerProperties() == null ? null : this.innerProperties().changes();
    }

    /**
     * Set the changes property: List of resource changes predicted by What-If operation.
     *
     * @param changes the changes value to set.
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withChanges(List<WhatIfChange> changes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WhatIfOperationProperties();
        }
        this.innerProperties().withChanges(changes);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
