// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Authorization Profile. */
@Immutable
public final class AuthorizationProfile {
    /*
     * The requested time
     */
    @JsonProperty(value = "requestedTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime requestedTime;

    /*
     * The requester
     */
    @JsonProperty(value = "requester", access = JsonProperty.Access.WRITE_ONLY)
    private String requester;

    /*
     * The requester object id
     */
    @JsonProperty(value = "requesterObjectId", access = JsonProperty.Access.WRITE_ONLY)
    private String requesterObjectId;

    /*
     * The approved time
     */
    @JsonProperty(value = "approvedTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime approvedTime;

    /*
     * The approver
     */
    @JsonProperty(value = "approver", access = JsonProperty.Access.WRITE_ONLY)
    private String approver;

    /** Creates an instance of AuthorizationProfile class. */
    public AuthorizationProfile() {
    }

    /**
     * Get the requestedTime property: The requested time.
     *
     * @return the requestedTime value.
     */
    public OffsetDateTime requestedTime() {
        return this.requestedTime;
    }

    /**
     * Get the requester property: The requester.
     *
     * @return the requester value.
     */
    public String requester() {
        return this.requester;
    }

    /**
     * Get the requesterObjectId property: The requester object id.
     *
     * @return the requesterObjectId value.
     */
    public String requesterObjectId() {
        return this.requesterObjectId;
    }

    /**
     * Get the approvedTime property: The approved time.
     *
     * @return the approvedTime value.
     */
    public OffsetDateTime approvedTime() {
        return this.approvedTime;
    }

    /**
     * Get the approver property: The approver.
     *
     * @return the approver value.
     */
    public String approver() {
        return this.approver;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
