// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.fluent.models.ChangeResourceResultInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of resources. */
@Fluent
public final class ChangeResourceListResult {
    /*
     * The link used to get the next page of Change Resources
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /*
     * The list of resources
     */
    @JsonProperty(value = "value")
    private List<ChangeResourceResultInner> value;

    /** Creates an instance of ChangeResourceListResult class. */
    public ChangeResourceListResult() {
    }

    /**
     * Get the nextLink property: The link used to get the next page of Change Resources.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of Change Resources.
     *
     * @param nextLink the nextLink value to set.
     * @return the ChangeResourceListResult object itself.
     */
    public ChangeResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: The list of resources.
     *
     * @return the value value.
     */
    public List<ChangeResourceResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of resources.
     *
     * @param value the value value to set.
     * @return the ChangeResourceListResult object itself.
     */
    public ChangeResourceListResult withValue(List<ChangeResourceResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
